/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.gradle.api.internal.artifacts.TransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.DefaultVariantDefinition;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.internal.collections.ImmutableFilteredList;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Project.class})
public class ConsumerProvidedVariantFinder {
    private final VariantTransformRegistry variantTransforms;
    private final AttributesFactory attributesFactory;
    private final Lazy<AttributeMatcher> matcher;
    private final TransformCache transformCache;

    public ConsumerProvidedVariantFinder(VariantTransformRegistry variantTransforms, AttributesSchemaInternal schema, AttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices) {
        this.variantTransforms = variantTransforms;
        this.attributesFactory = attributesFactory;
        this.matcher = Lazy.locking().of(() -> {
            ImmutableAttributesSchema immutable = attributeSchemaServices.getSchemaFactory().create(schema);
            return attributeSchemaServices.getMatcher(immutable, ImmutableAttributesSchema.EMPTY);
        });
        this.transformCache = new TransformCache(this::doFindTransformedVariants);
    }

    public List<TransformedVariant> findCandidateTransformationChains(List<ResolvedVariant> sources, ImmutableAttributes requested) {
        return this.transformCache.query(sources, requested);
    }

    private List<CachedVariant> doFindTransformedVariants(List<ImmutableAttributes> sources, ImmutableAttributes requested) {
        AttributeMatcher attributeMatcher = (AttributeMatcher)this.matcher.get();
        ArrayList<ChainState> toProcess = new ArrayList<ChainState>();
        ArrayList<ChainState> nextDepth = new ArrayList<ChainState>();
        toProcess.add(new ChainState(null, requested, (ImmutableFilteredList<TransformRegistration>)ImmutableFilteredList.allOf(new ArrayList<TransformRegistration>(this.variantTransforms.getRegistrations()))));
        ArrayList<CachedVariant> results = new ArrayList<CachedVariant>(1);
        while (results.isEmpty() && !toProcess.isEmpty()) {
            for (ChainState state : toProcess) {
                ImmutableFilteredList candidates = state.transforms.matching(transform -> attributeMatcher.isMatchingCandidate(transform.getTo(), state.requested));
                for (TransformRegistration candidate : candidates) {
                    for (int i = 0; i < sources.size(); ++i) {
                        ImmutableAttributes rootAttrs;
                        ImmutableAttributes sourceAttrs = sources.get(i);
                        if (!attributeMatcher.isMatchingCandidate(sourceAttrs, candidate.getFrom()) || !attributeMatcher.isMatchingCandidate(rootAttrs = this.attributesFactory.concat(sourceAttrs, candidate.getTo()), state.requested)) continue;
                        DefaultVariantDefinition rootTransformedVariant = new DefaultVariantDefinition(null, rootAttrs, candidate.getTransformStep());
                        VariantDefinition variantChain = this.createVariantChain(state.chain, rootTransformedVariant);
                        results.add(new CachedVariant(i, variantChain));
                    }
                }
                if (!results.isEmpty()) continue;
                for (int i = 0; i < candidates.size(); ++i) {
                    TransformRegistration candidate;
                    candidate = (TransformRegistration)candidates.get(i);
                    if (Collections.disjoint(state.requested.keySet(), candidate.getTo().keySet())) continue;
                    nextDepth.add(new ChainState(new ChainNode(state.chain, candidate), this.attributesFactory.concat(state.requested, candidate.getFrom()), (ImmutableFilteredList<TransformRegistration>)state.transforms.withoutIndexFrom(i, candidates)));
                }
            }
            toProcess.clear();
            ArrayList<ChainState> tmp = toProcess;
            toProcess = nextDepth;
            nextDepth = tmp;
        }
        return results;
    }

    private VariantDefinition createVariantChain(ChainNode stateChain, DefaultVariantDefinition root) {
        ChainNode node = stateChain;
        DefaultVariantDefinition last = root;
        while (node != null) {
            last = new DefaultVariantDefinition(last, this.attributesFactory.concat(last.getTargetAttributes(), node.transform.getTo()), node.transform.getTransformStep());
            node = node.next;
        }
        return last;
    }

    private static class TransformCache {
        private final ConcurrentHashMap<CacheKey, List<CachedVariant>> cache = new ConcurrentHashMap();
        private final BiFunction<List<ImmutableAttributes>, ImmutableAttributes, List<CachedVariant>> action;

        public TransformCache(BiFunction<List<ImmutableAttributes>, ImmutableAttributes, List<CachedVariant>> action) {
            this.action = action;
        }

        private List<TransformedVariant> query(List<ResolvedVariant> sources, ImmutableAttributes requested) {
            ArrayList<ImmutableAttributes> variantAttributes = new ArrayList<ImmutableAttributes>(sources.size());
            for (ResolvedVariant variant : sources) {
                variantAttributes.add(variant.getAttributes());
            }
            List cached = this.cache.computeIfAbsent(new CacheKey(variantAttributes, requested), key -> this.action.apply(((CacheKey)key).variantAttributes, ((CacheKey)key).requested));
            ArrayList<TransformedVariant> output = new ArrayList<TransformedVariant>(cached.size());
            for (CachedVariant variant : cached) {
                output.add(new TransformedVariant(sources.get(variant.sourceIndex), variant.chain));
            }
            return output;
        }

        private static class CacheKey {
            private final List<ImmutableAttributes> variantAttributes;
            private final ImmutableAttributes requested;
            private final int hashCode;

            public CacheKey(List<ImmutableAttributes> variantAttributes, ImmutableAttributes requested) {
                this.variantAttributes = variantAttributes;
                this.requested = requested;
                this.hashCode = 31 * variantAttributes.hashCode() + requested.hashCode();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)o;
                return this.variantAttributes.equals(cacheKey.variantAttributes) && this.requested.equals(cacheKey.requested);
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }

    private static class ChainState {
        final ChainNode chain;
        final ImmutableAttributes requested;
        final ImmutableFilteredList<TransformRegistration> transforms;

        public ChainState(@Nullable ChainNode chain, ImmutableAttributes requested, ImmutableFilteredList<TransformRegistration> transforms) {
            this.chain = chain;
            this.requested = requested;
            this.transforms = transforms;
        }
    }

    private static class ChainNode {
        final ChainNode next;
        final TransformRegistration transform;

        public ChainNode(@Nullable ChainNode next, TransformRegistration transform) {
            this.next = next;
            this.transform = transform;
        }
    }

    private static class CachedVariant {
        private final int sourceIndex;
        private final VariantDefinition chain;

        public CachedVariant(int sourceIndex, VariantDefinition chain) {
            this.sourceIndex = sourceIndex;
            this.chain = chain;
        }
    }
}

