/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.HttpClientUtils;

public class HttpClientResponse
implements Closeable {
    private final String method;
    private final URI effectiveUri;
    private final CloseableHttpResponse httpResponse;
    private boolean closed;

    HttpClientResponse(String method, URI effectiveUri, CloseableHttpResponse httpResponse) {
        this.method = method;
        this.effectiveUri = effectiveUri;
        this.httpResponse = httpResponse;
    }

    public String getHeader(String name) {
        Header header = this.httpResponse.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    public InputStream getContent() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        if (entity == null) {
            throw new IOException(String.format("Response %d: %s has no content!", this.getStatusLine().getStatusCode(), this.getStatusLine().getReasonPhrase()));
        }
        return entity.getContent();
    }

    public StatusLine getStatusLine() {
        return this.httpResponse.getStatusLine();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            HttpClientUtils.closeQuietly((CloseableHttpResponse)this.httpResponse);
        }
    }

    String getMethod() {
        return this.method;
    }

    URI getEffectiveUri() {
        return this.effectiveUri;
    }

    boolean wasSuccessful() {
        int statusCode = this.getStatusLine().getStatusCode();
        return statusCode >= 200 && statusCode < 400;
    }

    boolean wasMissing() {
        int statusCode = this.getStatusLine().getStatusCode();
        return statusCode == 404;
    }
}

