import { jsx } from 'react/jsx-runtime';
import { memo } from 'react';
import Calendar from 'react-calendar';
import { useTheme2, ClickOutsideWrapper, Icon } from '@grafana/ui';
import { getStyles, getBodyStyles } from './styles.js';

const DatePicker = memo((props) => {
  const theme = useTheme2();
  const styles = getStyles(theme);
  const { isOpen, onClose } = props;
  if (!isOpen) {
    return null;
  }
  return /* @__PURE__ */ jsx(ClickOutsideWrapper, { useCapture: true, includeButtonPress: false, onClick: onClose, children: /* @__PURE__ */ jsx("div", { className: styles.modal, "data-testid": "date-picker", children: /* @__PURE__ */ jsx(Body, { ...props }) }) });
});
DatePicker.displayName = "DatePicker";
const Body = memo(({ value, onChange }) => {
  const theme = useTheme2();
  const styles = getBodyStyles(theme);
  return /* @__PURE__ */ jsx(
    Calendar,
    {
      className: styles.body,
      tileClassName: styles.title,
      value: value || /* @__PURE__ */ new Date(),
      nextLabel: /* @__PURE__ */ jsx(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ jsx(Icon, { name: "angle-left" }),
      onChange: (ev) => {
        if (!Array.isArray(ev)) {
          onChange(ev);
        }
      },
      locale: "en"
    }
  );
});
Body.displayName = "Body";

export { DatePicker };
//# sourceMappingURL=DatePicker.js.map
