import { jsxs, jsx } from 'react/jsx-runtime';
import { useRef, useEffect } from 'react';
import { Modal, Icon, Button } from '@grafana/ui';

function ConfirmModal({ isOpen, onCancel, onDiscard, onCopy }) {
  const buttonRef = useRef(null);
  useEffect(() => {
    var _a;
    if (isOpen) {
      (_a = buttonRef.current) == null ? undefined : _a.focus();
    }
  }, [isOpen]);
  return /* @__PURE__ */ jsxs(
    Modal,
    {
      title: /* @__PURE__ */ jsxs("div", { className: "modal-header-title", children: [
        /* @__PURE__ */ jsx(Icon, { name: "exclamation-triangle", size: "lg" }),
        /* @__PURE__ */ jsx("span", { className: "p-l-1", children: "Warning" })
      ] }),
      onDismiss: onCancel,
      isOpen,
      children: [
        /* @__PURE__ */ jsx("p", { children: "Builder mode does not display changes made in code. The query builder will display the last changes you made in builder mode." }),
        /* @__PURE__ */ jsx("p", { children: "Do you want to copy your code to the clipboard?" }),
        /* @__PURE__ */ jsxs(Modal.ButtonRow, { children: [
          /* @__PURE__ */ jsx(Button, { type: "button", variant: "secondary", onClick: onCancel, fill: "outline", children: "Cancel" }),
          /* @__PURE__ */ jsx(Button, { variant: "destructive", type: "button", onClick: onDiscard, ref: buttonRef, children: "Discard code and switch" }),
          /* @__PURE__ */ jsx(Button, { variant: "primary", onClick: onCopy, children: "Copy code and switch" })
        ] })
      ]
    }
  );
}

export { ConfirmModal };
//# sourceMappingURL=ConfirmModal.js.map
