/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import sun.jvm.hotspot.ui.FrameWrapper;

public class JFrameWrapper
implements FrameWrapper {
    private JFrame frame;
    private boolean hasWindowListener;
    private ActionListener closingActionListener;
    private ActionListener activatedActionListener;

    public JFrameWrapper(JFrame frame) {
        this.frame = frame;
    }

    @Override
    public Component getComponent() {
        return this.frame;
    }

    @Override
    public Container getContentPane() {
        return this.frame.getContentPane();
    }

    @Override
    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    @Override
    public void setSize(int x, int y) {
        this.frame.setSize(x, y);
    }

    @Override
    public void pack() {
        this.frame.pack();
    }

    public void show() {
        this.frame.setVisible(true);
    }

    @Override
    public void dispose() {
        this.frame.dispose();
    }

    @Override
    public void setBackground(Color color) {
        this.frame.setBackground(color);
    }

    @Override
    public void setResizable(boolean resizable) {
        this.frame.setResizable(resizable);
    }

    @Override
    public void setClosable(boolean closable) {
        if (closable) {
            this.frame.setDefaultCloseOperation(1);
        } else {
            this.frame.setDefaultCloseOperation(0);
        }
    }

    @Override
    public void setClosingActionListener(ActionListener l) {
        this.closingActionListener = l;
        this.maybeInstallWindowListener();
    }

    @Override
    public void setActivatedActionListener(ActionListener l) {
        this.activatedActionListener = l;
        this.maybeInstallWindowListener();
    }

    @Override
    public void toFront() {
        this.frame.toFront();
        this.frame.requestFocus();
    }

    private void maybeInstallWindowListener() {
        if (!this.hasWindowListener) {
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (JFrameWrapper.this.closingActionListener != null) {
                        JFrameWrapper.this.closingActionListener.actionPerformed(null);
                    }
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    if (JFrameWrapper.this.activatedActionListener != null) {
                        JFrameWrapper.this.activatedActionListener.actionPerformed(null);
                    }
                }
            });
            this.hasWindowListener = true;
        }
    }
}

