/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.log.LoggerName;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.Logger;

@Singleton
public class LoggerProducer {
    private final ConcurrentMap<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();

    @Dependent
    @Produces
    @DefaultBean
    Logger getSimpleLogger(InjectionPoint injectionPoint) {
        return this.loggers.computeIfAbsent(injectionPoint.getMember().getDeclaringClass().getName(), Logger::getLogger);
    }

    @LoggerName(value="")
    @Dependent
    @Produces
    @DefaultBean
    Logger getLoggerWithCustomName(InjectionPoint injectionPoint) {
        String name = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(LoggerName.class)) continue;
            name = ((LoggerName)qualifier).value();
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalStateException("Unable to derive the logger name at " + String.valueOf(injectionPoint));
        }
        return this.loggers.computeIfAbsent(name, Logger::getLogger);
    }

    @PreDestroy
    void destroy() {
        this.loggers.clear();
    }
}

