/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.OffsetTimeProvider;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderFactory;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.JwtCredentialBuilder;
import org.keycloak.provider.ProviderConfigProperty;

public class JwtCredentialBuilderFactory
implements CredentialBuilderFactory {
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    @Override
    public String getSupportedFormat() {
        return "jwt_vc";
    }

    public String getHelpText() {
        return "Builds verifiable credentials on the JWT-VC format (https://identity.foundation/jwt-vc-presentation-profile).";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public CredentialBuilder create(KeycloakSession session, ComponentModel model) {
        return new JwtCredentialBuilder((TimeProvider)new OffsetTimeProvider(), session);
    }
}

