/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.store.ldap;

import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.keycloak.models.ModelException;
import org.keycloak.storage.ldap.LDAPConfig;

public class LDAPUtil {
    public static final String formatDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("You must provide a date.");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'.0Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static final Date parseDate(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            if (date.endsWith("Z")) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                dateFormat.setTimeZone(TimeZone.getDefault());
            }
            return dateFormat.parse(date);
        }
        catch (Exception e) {
            throw new ModelException("Error converting ldap date.", (Throwable)e);
        }
    }

    public static String convertObjectGUIDToByteString(byte[] objectGUID) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < objectGUID.length; ++i) {
            String transformed = LDAPUtil.prefixZeros(objectGUID[i] & 0xFF);
            result.append("\\");
            result.append(transformed);
        }
        return result.toString();
    }

    public static String convertGUIDToEdirectoryHexString(String guid) {
        String withoutDash = guid.replace("-", "");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < withoutDash.length(); ++i) {
            result.append("\\");
            result.append(withoutDash.charAt(i));
            result.append(withoutDash.charAt(++i));
        }
        return result.toString().toUpperCase();
    }

    public static byte[] encodeObjectEDirectoryGUID(String guid) {
        String withoutDash = guid.replace("-", "");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        for (int i = 0; i < withoutDash.length(); ++i) {
            String byteStr = "" + withoutDash.charAt(i) + withoutDash.charAt(++i);
            result.write(Integer.parseInt(byteStr, 16));
        }
        return result.toByteArray();
    }

    public static byte[] encodeObjectGUID(String displayString) {
        byte[] objectGUID = new byte[]{(byte)((Character.digit(displayString.charAt(6), 16) << 4) + Character.digit(displayString.charAt(7), 16)), (byte)((Character.digit(displayString.charAt(4), 16) << 4) + Character.digit(displayString.charAt(5), 16)), (byte)((Character.digit(displayString.charAt(2), 16) << 4) + Character.digit(displayString.charAt(3), 16)), (byte)((Character.digit(displayString.charAt(0), 16) << 4) + Character.digit(displayString.charAt(1), 16)), (byte)((Character.digit(displayString.charAt(11), 16) << 4) + Character.digit(displayString.charAt(12), 16)), (byte)((Character.digit(displayString.charAt(9), 16) << 4) + Character.digit(displayString.charAt(10), 16)), (byte)((Character.digit(displayString.charAt(16), 16) << 4) + Character.digit(displayString.charAt(17), 16)), (byte)((Character.digit(displayString.charAt(14), 16) << 4) + Character.digit(displayString.charAt(15), 16)), (byte)((Character.digit(displayString.charAt(19), 16) << 4) + Character.digit(displayString.charAt(20), 16)), (byte)((Character.digit(displayString.charAt(21), 16) << 4) + Character.digit(displayString.charAt(22), 16)), (byte)((Character.digit(displayString.charAt(24), 16) << 4) + Character.digit(displayString.charAt(25), 16)), (byte)((Character.digit(displayString.charAt(26), 16) << 4) + Character.digit(displayString.charAt(27), 16)), (byte)((Character.digit(displayString.charAt(28), 16) << 4) + Character.digit(displayString.charAt(29), 16)), (byte)((Character.digit(displayString.charAt(30), 16) << 4) + Character.digit(displayString.charAt(31), 16)), (byte)((Character.digit(displayString.charAt(32), 16) << 4) + Character.digit(displayString.charAt(33), 16)), (byte)((Character.digit(displayString.charAt(34), 16) << 4) + Character.digit(displayString.charAt(35), 16))};
        return objectGUID;
    }

    public static String decodeObjectGUID(byte[] objectGUID) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(LDAPUtil.convertToDashedString(objectGUID));
        return displayStr.toString();
    }

    public static String decodeGuid(byte[] guid) {
        byte[] withBigEndian = new byte[]{guid[3], guid[2], guid[1], guid[0], guid[5], guid[4], guid[7], guid[6], guid[8], guid[9], guid[10], guid[11], guid[12], guid[13], guid[14], guid[15]};
        return LDAPUtil.convertToDashedString(withBigEndian);
    }

    private static String convertToDashedString(byte[] objectGUID) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[3] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[2] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[1] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[0] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[5] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[4] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[7] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[6] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[8] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[9] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[10] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[11] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[12] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[13] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[14] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[15] & 0xFF));
        return displayStr.toString();
    }

    private static String prefixZeros(int value) {
        if (value <= 15) {
            StringBuilder sb = new StringBuilder("0");
            sb.append(Integer.toHexString(value));
            return sb.toString();
        }
        return Integer.toHexString(value);
    }

    public static boolean shouldUseTruststoreSpi(LDAPConfig ldapConfig) {
        boolean useSSL = ldapConfig.getConnectionUrl().toLowerCase().contains("ldaps://");
        boolean defaultUseTruststore = useSSL || ldapConfig.isStartTls();
        String useTruststoreSpi = ldapConfig.getUseTruststoreSpi();
        if (useTruststoreSpi == null) {
            return defaultUseTruststore;
        }
        if ("never".equals(useTruststoreSpi)) {
            return false;
        }
        return defaultUseTruststore;
    }
}

