RSpec.describe MetasploitDataModels::AutomaticExploitation::Match, type: :model do
  it_should_behave_like 'Metasploit::Concern.run'

  describe "associations" do
    describe "connecting to a Mdm::Module::Detail" do
      let(:vuln){ FactoryBot.create(:mdm_vuln) }
      let(:module_detail){FactoryBot.create(:mdm_module_detail)}

      subject(:automatic_exploitation_match){ described_class.new }

      before(:example) do
        automatic_exploitation_match.matchable = vuln
        automatic_exploitation_match.module_fullname = module_detail.fullname
        automatic_exploitation_match.save!
      end

      it 'should point to the Mdm::Module::Detail with a fullname corresponding to #module_fullname' do
        expect(automatic_exploitation_match.module_detail).to eq(module_detail)
      end
    end

    describe "deleting the associated Mdm::Module::Detail" do
      subject(:automatic_exploitation_match){ FactoryBot.create(:automatic_exploitation_match) }
      let(:match_id){ automatic_exploitation_match.id }

      before(:example) do
        automatic_exploitation_match.module_detail.destroy
      end

      it 'should still exist in the DB' do
        the_match = MetasploitDataModels::AutomaticExploitation::Match.find(match_id)
        expect(the_match).to_not be_blank
      end
    end

  end
end
