/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import org.opensearch.sql.planner.physical.SortHelper;

public class TakeOrderedOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final List<Pair<Sort.SortOption, Expression>> sortList;
    private final Integer limit;
    private final Integer offset;
    private final Ordering<ExprValue> ordering;
    private Iterator<ExprValue> iterator;

    public TakeOrderedOperator(PhysicalPlan input, Integer limit, Integer offset, List<Pair<Sort.SortOption, Expression>> sortList) {
        this.input = input;
        this.sortList = sortList;
        this.limit = limit;
        this.offset = offset;
        this.ordering = SortHelper.constructExprOrdering(sortList);
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitTakeOrdered(this, context);
    }

    @Override
    public void open() {
        super.open();
        this.iterator = this.ordering.leastOf((Iterator)this.input, this.offset + this.limit).stream().skip(this.offset.intValue()).iterator();
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.iterator.next();
    }

    @Generated
    public String toString() {
        return "TakeOrderedOperator(input=" + String.valueOf(this.getInput()) + ", sortList=" + String.valueOf(this.getSortList()) + ", limit=" + this.getLimit() + ", offset=" + this.getOffset() + ", ordering=" + String.valueOf(this.ordering) + ", iterator=" + String.valueOf(this.iterator) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TakeOrderedOperator)) {
            return false;
        }
        TakeOrderedOperator other = (TakeOrderedOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<Pair<Sort.SortOption, Expression>> this$sortList = this.getSortList();
        List<Pair<Sort.SortOption, Expression>> other$sortList = other.getSortList();
        return !(this$sortList == null ? other$sortList != null : !((Object)this$sortList).equals(other$sortList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TakeOrderedOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<Pair<Sort.SortOption, Expression>> $sortList = this.getSortList();
        result = result * 59 + ($sortList == null ? 43 : ((Object)$sortList).hashCode());
        return result;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<Pair<Sort.SortOption, Expression>> getSortList() {
        return this.sortList;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public Integer getOffset() {
        return this.offset;
    }
}

