"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSettingsSpecSelector = exports.getSpecs = void 0;
var ts_debounce_1 = require("ts-debounce");
var chart_types_1 = require("../../chart_types");
var constants_1 = require("../../specs/constants");
var create_selector_1 = require("../create_selector");
var utils_1 = require("../utils");
var DEFAULT_POINTER_UPDATE_DEBOUNCE = 16;
var getSpecs = function (state) { return state.specs; };
exports.getSpecs = getSpecs;
exports.getSettingsSpecSelector = create_selector_1.createCustomCachedSelector([exports.getSpecs], function (specs) {
    var settingsSpecs = utils_1.getSpecsFromStore(specs, chart_types_1.ChartType.Global, constants_1.SpecType.Settings);
    if (settingsSpecs.length === 1) {
        return handleListenerDebouncing(settingsSpecs[0]);
    }
    return constants_1.DEFAULT_SETTINGS_SPEC;
});
function handleListenerDebouncing(settings) {
    var _a;
    var delay = (_a = settings.pointerUpdateDebounce) !== null && _a !== void 0 ? _a : DEFAULT_POINTER_UPDATE_DEBOUNCE;
    if (settings.onPointerUpdate)
        settings.onPointerUpdate = ts_debounce_1.debounce(settings.onPointerUpdate, delay);
    return settings;
}
//# sourceMappingURL=get_settings_specs.js.map