/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeAttributes;
import org.opensearch.client.opensearch._types.NodeShard;
import org.opensearch.client.opensearch.core.search_shards.ShardStoreIndex;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SearchShardsResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SearchShardsResponse> {
    @Nonnull
    private final Map<String, ShardStoreIndex> indices;
    @Nonnull
    private final Map<String, NodeAttributes> nodes;
    @Nonnull
    private final List<List<NodeShard>> shards;
    public static final JsonpDeserializer<SearchShardsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchShardsResponse::setupSearchShardsResponseDeserializer);

    private SearchShardsResponse(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
    }

    public static SearchShardsResponse of(Function<Builder, ObjectBuilder<SearchShardsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, ShardStoreIndex> indices() {
        return this.indices;
    }

    @Nonnull
    public final Map<String, NodeAttributes> nodes() {
        return this.nodes;
    }

    @Nonnull
    public final List<List<NodeShard>> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartObject();
        for (Map.Entry<String, ShardStoreIndex> entry : this.indices.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, ToCopyableBuilder<ShardStoreIndex.Builder, ShardStoreIndex>> entry : this.nodes.entrySet()) {
            generator.writeKey(entry.getKey());
            ((NodeAttributes)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("shards");
        generator.writeStartArray();
        for (List list : this.shards) {
            generator.writeStartArray();
            for (NodeShard item1 : list) {
                item1.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSearchShardsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(ShardStoreIndex._DESERIALIZER), "indices");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeAttributes._DESERIALIZER), "nodes");
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(NodeShard._DESERIALIZER)), "shards");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.indices.hashCode();
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardsResponse other = (SearchShardsResponse)o;
        return this.indices.equals(other.indices) && this.nodes.equals(other.nodes) && this.shards.equals(other.shards);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SearchShardsResponse> {
        private Map<String, ShardStoreIndex> indices;
        private Map<String, NodeAttributes> nodes;
        private List<List<NodeShard>> shards;

        public Builder() {
        }

        private Builder(SearchShardsResponse o) {
            this.indices = Builder._mapCopy(o.indices);
            this.nodes = Builder._mapCopy(o.nodes);
            this.shards = Builder._listCopy(o.shards);
        }

        private Builder(Builder o) {
            this.indices = Builder._mapCopy(o.indices);
            this.nodes = Builder._mapCopy(o.nodes);
            this.shards = Builder._listCopy(o.shards);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder indices(Map<String, ShardStoreIndex> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, ShardStoreIndex value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, Function<ShardStoreIndex.Builder, ObjectBuilder<ShardStoreIndex>> fn) {
            return this.indices(key, fn.apply(new ShardStoreIndex.Builder()).build());
        }

        @Nonnull
        public final Builder nodes(Map<String, NodeAttributes> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, NodeAttributes value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.nodes(key, fn.apply(new NodeAttributes.Builder()).build());
        }

        @Nonnull
        public final Builder shards(List<List<NodeShard>> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        @Nonnull
        public final Builder shards(List<NodeShard> value, List<NodeShard> ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        @Override
        @Nonnull
        public SearchShardsResponse build() {
            this._checkSingleUse();
            return new SearchShardsResponse(this);
        }
    }
}

