/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.KMAC;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DerivationFunction;
import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.KDFParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class NoCounterKDFGenerator
implements DerivationFunction {
    private final Digest digest;
    private final Mac mac;
    private byte[] shared;
    private byte[] otherInfo;
    private int hLen;
    private int requiredLen;

    public NoCounterKDFGenerator(Digest digest) {
        this.digest = digest;
        this.mac = null;
        this.hLen = digest.getDigestSize();
    }

    public NoCounterKDFGenerator(Mac mac) {
        this.mac = mac;
        this.digest = null;
        this.hLen = mac.getMacSize();
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFParameters) {
            KDFParameters kDFParameters = (KDFParameters)derivationParameters;
            this.shared = kDFParameters.getSharedSecret();
            this.otherInfo = kDFParameters.getIV();
            if (this.mac != null) {
                byte[] byArray = kDFParameters.getSalt();
                if (kDFParameters.getSalt() == null) {
                    if (this.mac instanceof HMac) {
                        byArray = new byte[((HMac)this.mac).getUnderlyingDigest().getByteLength()];
                    } else if (this.mac instanceof KMAC) {
                        byArray = new byte[((KMAC)this.mac).getByteLength() - 4];
                    } else {
                        throw new IllegalArgumentException("cannot recognise MAC");
                    }
                }
                this.mac.init(new KeyParameterImpl(byArray));
            }
        } else {
            throw new IllegalArgumentException("KDF parameters required for KDF generator");
        }
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (this.digest != null) {
            return this.digestGenerateBytes(byArray, n, n2);
        }
        return this.macGenerateBytes(byArray, n, n2);
    }

    private int macGenerateBytes(byte[] byArray, int n, int n2) {
        this.mac.update(this.shared, 0, this.shared.length);
        if (this.otherInfo != null) {
            this.mac.update(this.otherInfo, 0, this.otherInfo.length);
        }
        if (this.mac instanceof KMAC) {
            ((KMAC)this.mac).doFinal(byArray, n, n2);
        } else {
            if (n2 > this.hLen) {
                throw new IllegalArgumentException("requested length too large for KDF output");
            }
            byte[] byArray2 = new byte[this.hLen];
            this.mac.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n, n2);
            Arrays.fill(byArray2, (byte)0);
        }
        return n2;
    }

    private int digestGenerateBytes(byte[] byArray, int n, int n2) {
        if (n2 > this.hLen) {
            throw new IllegalArgumentException("requested length too large for KDF output");
        }
        this.digest.update(this.shared, 0, this.shared.length);
        if (this.otherInfo != null) {
            this.digest.update(this.otherInfo, 0, this.otherInfo.length);
        }
        byte[] byArray2 = new byte[this.hLen];
        this.digest.doFinal(byArray2, 0);
        System.arraycopy(byArray2, 0, byArray, n, n2);
        Arrays.fill(byArray2, (byte)0);
        return n2;
    }
}

