/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular;

import java.util.function.Predicate;

public final class CryptUtil {
    private CryptUtil() {
    }

    public static int parseInt(String value, Predicate<Integer> require, int defaultValue) {
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        return require.test(i) ? i : defaultValue;
    }

    public static <T> T assertNotNullArg(T o, String msg) {
        if (o == null) {
            throw new IllegalArgumentException(msg);
        }
        return o;
    }

    public static <T> T assertNotNullArgOr(T o, Predicate<T> predicate, String msg) {
        try {
            if (o == null || predicate.test(o)) {
                throw new IllegalArgumentException(msg);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return o;
    }
}

