/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.pem;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bouncycastle.util.io.pem.PemHeader;
import org.cryptacular.CryptUtil;
import org.cryptacular.EncodingException;
import org.cryptacular.pem.Constants;
import org.cryptacular.pem.Descriptor;
import org.cryptacular.pem.Format;
import org.cryptacular.pem.PemParser;

public final class PemObject
extends org.bouncycastle.util.io.pem.PemObject {
    private final Descriptor descriptor;

    public PemObject(Descriptor descriptorParam, byte[] content) {
        super(CryptUtil.assertNotNullArg(descriptorParam, "Descriptor cannot be null").getType(), CryptUtil.assertNotNullArg(content, "Content cannot be null"));
        this.descriptor = descriptorParam;
    }

    public PemObject(Descriptor descriptorParam, List<PemHeader> headers, byte[] content) {
        super(CryptUtil.assertNotNullArg(descriptorParam, "Descriptor cannot be null").getType(), CryptUtil.assertNotNullArg(headers, "Headers cannot be null"), CryptUtil.assertNotNullArg(content, "Content cannot be null"));
        this.descriptor = descriptorParam;
        this.assertHeadersValid(headers);
    }

    public static PemObject decode(byte[] encoded) throws EncodingException {
        PemParser parser = new PemParser();
        return parser.parse(encoded);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void assertHeadersValid(List<PemHeader> headers) {
        switch (this.descriptor.getFormat()) {
            case RFC1421: {
                this.assertPemHeaderValid(headers, Constants.RFC1421_SPECIFIERS, Format.RFC1421, false, true);
                break;
            }
            case RFC2440: {
                this.assertPemHeaderValid(headers, Constants.RFC2440_SPECIFIERS, Format.RFC2440, false, false);
                break;
            }
            case RFC4716: {
                this.assertPemHeaderValid(headers, Constants.RFC4716_SPECIFIERS, Format.RFC4716, true, false);
                break;
            }
            case RFC7468: {
                throw new IllegalArgumentException("Headers are not allowed in this PEM format specified (RFC 7468)");
            }
        }
    }

    private void assertPemHeaderValid(List<PemHeader> headers, Set<String> specifiers, Format format, boolean allowX, boolean disregardX) throws IllegalArgumentException {
        for (PemHeader header : headers) {
            if (header.getName() == null) {
                throw new IllegalArgumentException("Neither a supplied PemHeader nor its name may be null");
            }
            boolean isXHeader = header.getName().toLowerCase(Locale.ROOT).startsWith("x-");
            String headerName = disregardX && isXHeader ? header.getName().substring(2) : header.getName();
            if (specifiers.contains(headerName) || allowX || !isXHeader) continue;
            throw new IllegalArgumentException(String.format("Invalid header \"%s\" specified in PEM format (%s)", header.getName(), format.name()));
        }
    }
}

