/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.remote;

import java.io.IOException;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

@org.opensearch.ml.common.annotation.MLInput(functionNames={FunctionName.REMOTE})
public class RemoteInferenceMLInput
extends MLInput {
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String ACTION_TYPE_FIELD = "action_type";
    public static final String DLQ_FIELD = "dlq";

    public RemoteInferenceMLInput(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public RemoteInferenceMLInput(XContentParser parser, FunctionName functionName) throws IOException {
        this.algorithm = functionName;
        Map<String, String> parameters = null;
        Map<String, String> dlq = null;
        ConnectorAction.ActionType actionType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "parameters": {
                    parameters = StringUtils.getParameterMap(parser.map());
                    continue block10;
                }
                case "action_type": {
                    actionType = ConnectorAction.ActionType.from(parser.text());
                    continue block10;
                }
                case "dlq": {
                    dlq = StringUtils.getParameterMap(parser.map());
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        this.inputDataset = new RemoteInferenceInputDataSet(parameters, actionType, dlq);
    }
}

