/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.lib.PyDictSetItemNodeGen;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyDictSetItem
extends Node {
    public static void executeUncached(PDict dict, Object key, Object item) {
        PyDictSetItem.getUncached().execute(null, null, dict, key, item);
    }

    public final void execute(Node inliningTarget, PDict dict, TruffleString key, Object item) {
        this.execute(null, inliningTarget, dict, key, item);
    }

    public abstract void execute(Frame var1, Node var2, PDict var3, Object var4, Object var5);

    @Specialization
    static void setItemWithStringKey(Node inliningTarget, PDict dict, TruffleString key, Object item, @Cached.Shared(value="setItem") @Cached(inline=false) HashingStorageNodes.HashingStorageSetItem setItem, @Cached.Shared(value="updateStorage") @Cached InlinedCountingConditionProfile updateStorageProfile) {
        HashingStorage dictStorage = dict.getDictStorage();
        HashingStorage updatedStorage = setItem.execute(inliningTarget, dictStorage, key, item);
        if (updateStorageProfile.profile(inliningTarget, updatedStorage != dictStorage)) {
            dict.setDictStorage(updatedStorage);
        }
    }

    @Specialization(replaces={"setItemWithStringKey"})
    static void setItemCached(VirtualFrame frame, Node inliningTarget, PDict dict, Object key, Object item, @Cached.Shared(value="setItem") @Cached(inline=false) HashingStorageNodes.HashingStorageSetItem setItem, @Cached.Shared(value="updateStorage") @Cached InlinedCountingConditionProfile updateStorageProfile) {
        HashingStorage dictStorage = dict.getDictStorage();
        HashingStorage updatedStorage = setItem.execute((Frame)frame, inliningTarget, dictStorage, key, item);
        if (updateStorageProfile.profile(inliningTarget, updatedStorage != dictStorage)) {
            dict.setDictStorage(updatedStorage);
        }
    }

    @Specialization(replaces={"setItemCached"})
    static void setItem(Node inliningTarget, PDict dict, Object key, Object item, @Cached.Shared(value="setItem") @Cached(inline=false) HashingStorageNodes.HashingStorageSetItem setItem, @Cached.Shared(value="updateStorage") @Cached InlinedCountingConditionProfile updateStorageProfile) {
        HashingStorage dictStorage = dict.getDictStorage();
        HashingStorage updatedStorage = setItem.execute(null, inliningTarget, dictStorage, key, item);
        if (updateStorageProfile.profile(inliningTarget, updatedStorage != dictStorage)) {
            dict.setDictStorage(updatedStorage);
        }
    }

    public static PyDictSetItem getUncached() {
        return PyDictSetItemNodeGen.getUncached();
    }
}

