-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2026, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  'HOST_NAME' AS NAME,
  HOST_NAME AS VALUE,
  'Server host name.' AS DESCRIPTION
FROM
  SYSIBMADM.ENV_SYS_INFO
UNION ALL
SELECT
  'OS_NAME' AS NAME,
  OS_NAME AS VALUE,
  'Server operating system.' AS DESCRIPTION
FROM
  SYSIBMADM.ENV_SYS_INFO
UNION ALL
SELECT
  'TOTAL_CPUS' AS NAME,
  CAST(TOTAL_CPUS AS VARCHAR) AS VALUE,
  'Server total CPUs.' AS DESCRIPTION
FROM
  SYSIBMADM.ENV_SYS_INFO
UNION ALL
SELECT
  'TOTAL_MEMORY' AS NAME,
  CAST(TOTAL_MEMORY AS VARCHAR) AS VALUE,
  'Server total memory.' AS DESCRIPTION
FROM
  SYSIBMADM.ENV_SYS_INFO
UNION ALL  
SELECT 
  'CURRENT_SERVER' AS NAME,
  CURRENT SERVER AS VALUE,
  'Current server or database name.' AS DESCRIPTION
FROM 
  SYSIBM.SYSDUMMY1
UNION ALL    
SELECT 
  'INST_NAME' AS NAME,
  E.INST_NAME AS VALUE,
  'Instance name.' AS DESCRIPTION
FROM 
  SYSIBMADM.ENV_INST_INFO E 
;