/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.mappingproxy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.mappingproxy.MappingproxyBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.mappingproxy.MappingproxyBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.mappingproxy.PMappingproxy;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyNumberOrNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompare;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMappingproxy})
public final class MappingproxyBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MappingproxyBuiltinsSlotsGen.SLOTS;

    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MappingproxyBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        ReversedNode() {
        }

        @Specialization
        static Object reversed(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T___REVERSED__, new Object[0]);
        }
    }

    @Slot(value=Slot.SlotKind.nb_inplace_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class IOrNode
    extends PythonBinaryBuiltinNode {
        IOrNode() {
        }

        @Specialization
        static Object or(Object self, Object other, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IOR_IS_NOT_SUPPORTED_BY_P_USE_INSTEAD, self);
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        static Object or(VirtualFrame frame, Object self, Object other, @Cached PyNumberOrNode orNode) {
            if (self instanceof PMappingproxy) {
                self = ((PMappingproxy)self).getMapping();
            }
            if (other instanceof PMappingproxy) {
                other = ((PMappingproxy)other).getMapping();
            }
            return orNode.execute(frame, self, other);
        }
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString mappingRepr = reprNode.execute((Frame)frame, inliningTarget, self.getMapping());
            return simpleTruffleStringFormatNode.format("mappingproxy(%s)", mappingRepr);
        }
    }

    @Slot(value=Slot.SlotKind.tp_str, isComplex=true)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }

        @Specialization
        static Object str(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectStrAsObjectNode strNode) {
            return strNode.execute((Frame)frame, inliningTarget, self.getMapping());
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class MappingproxyRichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization
        Object doIt(VirtualFrame frame, PMappingproxy self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyObjectRichCompare cmpNode) {
            return cmpNode.execute(frame, inliningTarget, self.getMapping(), other, op);
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object copy(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_COPY, new Object[0]);
        }
    }

    @Slot(value=Slot.SlotKind.mp_length, isComplex=true)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        public int len(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            return sizeNode.execute((Frame)frame, inliningTarget, self.getMapping());
        }
    }

    @Slot(value=Slot.SlotKind.sq_contains, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ContainsNode
    extends TpSlotSqContains.SqContainsBuiltinNode {
        @Specialization
        boolean run(VirtualFrame frame, PMappingproxy self, Object key, @Bind Node inliningTarget, @Cached PySequenceContainsNode containsNode) {
            return containsNode.execute((Frame)frame, inliningTarget, self.getMapping(), key);
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Specialization
        Object getItem(VirtualFrame frame, PMappingproxy self, Object key, @Bind Node inliningTarget, @Cached PyObjectGetItem getItemNode) {
            return getItemNode.execute((Frame)frame, inliningTarget, self.getMapping(), key);
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class GetNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(defaultValue)"})
        public Object get(VirtualFrame frame, PMappingproxy self, Object key, PNone defaultValue, @Bind Node inliningTarget, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_GET, key);
        }

        @Specialization(guards={"!isNoValue(defaultValue)"})
        public Object get(VirtualFrame frame, PMappingproxy self, Object key, Object defaultValue, @Bind Node inliningTarget, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_GET, key, defaultValue);
        }
    }

    @Builtin(name="values", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ValuesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object values(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_VALUES, new Object[0]);
        }
    }

    @Builtin(name="items", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ItemsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object items(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_ITEMS, new Object[0]);
        }
    }

    @Builtin(name="keys", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class KeysNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object items(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_KEYS, new Object[0]);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(VirtualFrame frame, PMappingproxy self, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter) {
            return getIter.execute((Frame)frame, inliningTarget, self.getMapping());
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="mappingproxy", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object doPMappingproxy(PMappingproxy self, Object mapping) {
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="mappingproxy", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class MappingproxyNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"!isNoValue(obj)"})
        static Object doMapping(Object cls, Object obj, @Bind Node inliningTarget, @Cached PyMappingCheckNode mappingCheckNode, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            if (!(obj instanceof PList) && !(obj instanceof PTuple) && mappingCheckNode.execute(inliningTarget, obj)) {
                return PFactory.createMappingproxy(language, obj);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "mappingproxy()", "mapping", obj);
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object doMissing(Object klass, PNone none, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MISSING_D_REQUIRED_S_ARGUMENT_S_POS, "mappingproxy()", "mapping", 1);
        }
    }
}

