/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import javax.websocket.EncodeException;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WrappedMessageHandler;
import org.apache.tomcat.websocket.WsSession;

public abstract class PojoMessageHandlerBase<T>
implements WrappedMessageHandler {
    private final Log log = LogFactory.getLog(PojoMessageHandlerBase.class);
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerBase.class);
    protected final Object pojo;
    protected final Method method;
    protected final Session session;
    protected final Object[] params;
    protected final int indexPayload;
    protected final boolean convert;
    protected final int indexSession;
    protected final long maxMessageSize;

    public PojoMessageHandlerBase(Object object, Method method, Session session, Object[] objectArray, int n, boolean bl, int n2, long l) {
        this.pojo = object;
        this.method = method;
        try {
            this.method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session = session;
        this.params = objectArray;
        this.indexPayload = n;
        this.convert = bl;
        this.indexSession = n2;
        this.maxMessageSize = l;
    }

    protected final void processResult(Object object) {
        if (object == null) {
            return;
        }
        RemoteEndpoint.Basic basic = this.session.getBasicRemote();
        try {
            if (object instanceof String) {
                basic.sendText((String)object);
            } else if (object instanceof ByteBuffer) {
                basic.sendBinary((ByteBuffer)object);
            } else if (object instanceof byte[]) {
                basic.sendBinary(ByteBuffer.wrap((byte[])object));
            } else {
                basic.sendObject(object);
            }
        }
        catch (IOException | EncodeException throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    @Override
    public final MessageHandler getWrappedHandler() {
        if (this.pojo instanceof MessageHandler) {
            return (MessageHandler)this.pojo;
        }
        return null;
    }

    @Override
    public final long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    protected final void handlePojoMethodException(Throwable throwable) {
        throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
        ExceptionUtils.handleThrowable((Throwable)throwable);
        if (throwable instanceof EncodeException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("pojoMessageHandlerBase.encodeFail", new Object[]{this.pojo.getClass().getName(), this.session.getId()}), throwable);
            }
        } else {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
        ((WsSession)this.session).getLocal().onError(this.session, throwable);
    }
}

