/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.regexp.RegexpMatcher;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.JSONUtils;

public final class JsonUtil {
    private static final String FUNCTION_PATTERN = "^function[ ]?\\(.*\\)[ ]?\\{.*\\}$";
    private static final RegexpMatcher FUNCTION_MACTHER = RegexpUtils.getMatcher((String)"^function[ ]?\\(.*\\)[ ]?\\{.*\\}$");

    private JsonUtil() {
    }

    private static boolean isFunction(String value) {
        return FUNCTION_MACTHER.matches(value);
    }

    public static String getJsonFriendlyString(String value) {
        if (!"null".equals(value) && (JSONUtils.mayBeJSON((String)value) || JsonUtil.isFunction(value))) {
            return "'" + value + "'";
        }
        return value;
    }

    public static List<String> toStringList(JSONArray array) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = JSONArray.toCollection((JSONArray)array).iterator();
        while (iter.hasNext()) {
            list.add(iter.next().toString());
        }
        return list;
    }

    public static String getJsonKeyString(Object obj) throws JSONException {
        StringBuilder sb = new StringBuilder();
        JsonUtil.appendJsonKeyString(obj, sb);
        if (sb.length() > 512) {
            return sb.substring(0, 509) + "...";
        }
        return sb.toString();
    }

    private static void appendJsonKeyString(Object obj, StringBuilder sb) throws JSONException {
        try {
            JsonUtil.appendJsonObjectKeyString(JSONObject.fromObject((Object)obj), sb);
        }
        catch (JSONException e) {
            JsonUtil.appendJsonArrayKeyString(JSONArray.fromObject((Object)obj), sb);
        }
    }

    private static void appendJsonObjectKeyString(JSONObject jsonObject, StringBuilder sb) {
        sb.append('{');
        String prefix = "";
        for (Object key : jsonObject.keySet()) {
            if (sb.length() > 512) break;
            sb.append(prefix);
            prefix = ",";
            Object obj = jsonObject.get(key);
            sb.append(key);
            if (obj instanceof JSONObject) {
                JSONObject jObj = (JSONObject)obj;
                sb.append(":");
                JsonUtil.appendJsonKeyString(jObj, sb);
                continue;
            }
            if (!(obj instanceof JSONArray)) continue;
            JSONArray jArr = (JSONArray)obj;
            sb.append(":");
            JsonUtil.appendJsonKeyString(jArr, sb);
        }
        sb.append('}');
    }

    private static void appendJsonArrayKeyString(JSONArray jsonArray, StringBuilder sb) {
        sb.append('[');
        String postfix = "..";
        Object[] oa = jsonArray.toArray();
        String lastChild = null;
        for (int i = 0; i < oa.length && sb.length() <= 512; ++i) {
            if (oa[i].getClass().isPrimitive() || oa[i] instanceof String) continue;
            StringBuilder sb2 = new StringBuilder();
            JsonUtil.appendJsonKeyString(oa[i], sb2);
            if (lastChild == null) {
                lastChild = sb2.toString();
                sb.append(lastChild);
                continue;
            }
            if (lastChild.equals(sb2.toString())) {
                sb.append(postfix);
                postfix = "";
                continue;
            }
            lastChild = sb2.toString();
            sb.append(',');
            sb.append(lastChild);
            postfix = "..";
        }
        sb.append(']');
    }
}

