/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;

class T4CRowidAccessor
extends RowidAccessor {
    private static final String CLASS_NAME = T4CRowidAccessor.class.getName();
    T4CMAREngine mare;
    final int[] meta = new int[1];
    static final int KGRD_EXTENDED_OBJECT = 6;
    static final int KGRD_EXTENDED_BLOCK = 6;
    static final int KGRD_EXTENDED_FILE = 3;
    static final int KGRD_EXTENDED_SLOT = 3;
    static final int kd4_ubridtype_physical = 1;
    static final int kd4_ubridtype_logical = 2;
    static final int kd4_ubridtype_remote = 3;
    static final int kd4_ubridtype_exttab = 4;
    static final int kd4_ubridtype_future2 = 5;
    static final int kd4_ubridtype_max = 5;
    static final int kd4_ubridlen_typeind = 1;
    static final int kd4_ubridlen_physobjd = 4;
    static final int kd4_ubridlen_physfno = 2;
    static final int kd4_ubridlen_physbno = 4;
    static final int kd4_ubridlen_physsno = 2;
    static final byte[] kgrd_indbyte_char = new byte[]{65, 42, 45, 40, 41};
    static final byte[] kgrd_basis_64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] kgrd_index_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    T4CRowidAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, isOutBind, false);
        this.mare = _mare;
        this.defineType = 104;
    }

    T4CRowidAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        this.mare = _mare;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
        this.defineType = 104;
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && (this.describeType == 112 || this.describeType == 127) || this.internalType == 23 && this.describeType == 113 || this.internalType == 112 && this.describeType == 127) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        this.rowData = dba;
        this.mare = ((T4CConnection)stmt.connection).mare;
        this.rowNull = null;
        this.setCapacity(stmt.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean isStream = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long pos = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(pos);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                isStream = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return isStream;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                if (!this.lastCopyRowIsNull) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(this.lastCopyRowOffset, this.lastCopyRowLength);
                    this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
                }
            } else {
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.lastCopyRow = -1;
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    AccessorPrototype newPrototype(int numRows) {
        assert (numRows >= 0) : "numRows: " + numRows;
        AccessorPrototype p = new AccessorPrototype(numRows, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement stmt) throws SQLException {
                T4CRowidAccessor acc = new T4CRowidAccessor(stmt, T4CRowidAccessor.this.describeMaxLength, T4CRowidAccessor.this.nullable, -1, T4CRowidAccessor.this.precision, T4CRowidAccessor.this.scale, T4CRowidAccessor.this.contflag, -1, T4CRowidAccessor.this.formOfUse, T4CRowidAccessor.this.definedColumnType, T4CRowidAccessor.this.definedColumnSize, null);
                this.initializeRowData(acc);
                return acc;
            }
        };
        return p;
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        int len;
        this.setOffset(this.lastRowProcessed);
        this.rowData.putShort((short)0);
        if (this.describeType == 208) {
            len = (int)this.mare.unmarshalUB4();
            if (len > 0) {
                ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, len);
            }
        } else {
            len = this.mare.unmarshalUB1();
            if (len > 0) {
                this.rowData.putInt((int)this.mare.unmarshalUB4());
                this.rowData.putShort((short)this.mare.unmarshalUB2());
                this.rowData.put((byte)this.mare.unmarshalUB1());
                this.rowData.putInt((int)this.mare.unmarshalUB4());
                this.rowData.putShort((short)this.mare.unmarshalUB2());
            }
        }
        this.processIndicator(len);
        this.rowData.putShort(this.getOffset(this.lastRowProcessed), (short)len);
        this.setLength(this.lastRowProcessed, (int)(this.rowData.getPosition() - this.getOffset(this.lastRowProcessed)));
        this.setNull(this.lastRowProcessed, len == 0);
        return false;
    }

    byte[] getDecodedBytes(int currentRow) throws SQLException {
        this.rowData.pushPosition(this.getOffset(currentRow));
        int meta = this.rowData.getShort();
        if (this.describeType == 208) {
            byte[] b0 = this.getBytesInternal(currentRow);
            byte[] b1 = new byte[4096];
            meta = T4CRowidAccessor.kgrdub2c(b0, meta, 2, b1, 2);
            b1[0] = (byte)(meta >> 8 & 0xFF);
            b1[1] = (byte)(meta & 0xFF);
            byte[] b2 = new byte[meta + 2];
            System.arraycopy(b1, 0, b2, 0, b2.length);
            this.rowData.popPosition();
            return b2;
        }
        short len = (short)meta;
        long rba = 0L;
        int partitionID = 0;
        short tableID = 0;
        long blockNumber = 0L;
        int slotNumber = 0;
        if (len > 0) {
            rba = (long)this.rowData.getInt() & 0xFFFFFFFFL;
            partitionID = this.rowData.getShort() & 0xFFFF;
            tableID = (short)(this.rowData.get() & 0xFF);
            blockNumber = (long)this.rowData.getInt() & 0xFFFFFFFFL;
            slotNumber = this.rowData.getShort() & 0xFFFF;
        }
        this.rowData.popPosition();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getDecodedBytes", "$1.unmarshalOneRow : len={0}, rba={1}, partition={2}, tableID={3}, blockNumber={4}, slotNumber={5}", (String)null, (Throwable)null, (Object)len, (Object)rba, (Object)partitionID, (Object)tableID, (Object)blockNumber, (Object)slotNumber);
        if (rba == 0L && partitionID == 0 && tableID == 0 && blockNumber == 0L && slotNumber == 0) {
            return null;
        }
        long[] args = new long[]{rba, partitionID, blockNumber, slotNumber};
        byte[] base64format = T4CRowidAccessor.rowidToString(args);
        int nbBytesToKeep = 18;
        if (this.byteLength - 2 < 18) {
            nbBytesToKeep = this.byteLength - 2;
        }
        byte[] result = new byte[nbBytesToKeep + 2];
        System.arraycopy(base64format, 0, result, 2, nbBytesToKeep);
        result[0] = (byte)((nbBytesToKeep & 0xFF00) >> 8);
        result[1] = (byte)(nbBytesToKeep & 0xFF);
        return result;
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] b = this.getDecodedBytes(currentRow);
        if (b == null) {
            return null;
        }
        long off = this.getOffset(currentRow);
        if (this.describeType == 208 && this.rowData.get(off + 2L) != 1) {
            int len = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
            return new String(b, 2, len, StandardCharsets.US_ASCII);
        }
        long[] l = T4CRowidAccessor.stringToRowid(b, 2, b.length - 2);
        return new String(T4CRowidAccessor.rowidToString(l), StandardCharsets.US_ASCII);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        if (this.isNull(currentRow)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(currentRow);
            }
            case -8: {
                return this.getROWID(currentRow);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] b0 = this.getDecodedBytes(currentRow);
        if (b0 == null) {
            return null;
        }
        byte[] b1 = new byte[b0.length - 2];
        System.arraycopy(b0, 2, b1, 0, b1.length);
        return b1;
    }

    static final byte[] rowidToString(long[] rowid) {
        long rba = rowid[0];
        long tidpid = rowid[1];
        long ridrba = rowid[2];
        long ridsqn = rowid[3];
        int size = 18;
        byte[] ret = new byte[size];
        int offset = 0;
        offset = T4CRowidAccessor.kgrd42b(ret, rba, 6, offset);
        offset = T4CRowidAccessor.kgrd42b(ret, tidpid, 3, offset);
        offset = T4CRowidAccessor.kgrd42b(ret, ridrba, 6, offset);
        offset = T4CRowidAccessor.kgrd42b(ret, ridsqn, 3, offset);
        return ret;
    }

    static final long[] rcToRowid(byte[] data, int offset, int length) throws SQLException {
        int size = 18;
        if (length != 18) {
            throw new SQLException("Rowid size incorrect.");
        }
        long[] ret = new long[4];
        String value = new String(data, offset, length, StandardCharsets.US_ASCII);
        long blockNumber = Long.parseLong(value.substring(0, 8), 16);
        long slotNumber = Long.parseLong(value.substring(9, 13), 16);
        long partitionID = Long.parseLong(value.substring(14, 18), 16);
        ret[0] = 0L;
        ret[1] = partitionID;
        ret[2] = blockNumber;
        ret[3] = slotNumber;
        return ret;
    }

    static final void kgrdr2rc(int tidrba, int tidpid, int tidtbl, int ridrba, int ridsqn, byte[] dstBytes, int offset) throws SQLException {
        offset = T4CRowidAccessor.lmx42h(dstBytes, ridrba, 8, offset);
        dstBytes[offset++] = 46;
        offset = T4CRowidAccessor.lmx42h(dstBytes, ridsqn, 4, offset);
        dstBytes[offset++] = 46;
        offset = T4CRowidAccessor.lmx42h(dstBytes, tidpid, 4, offset);
    }

    static final int lmx42h(byte[] charsAsBytes, long value, int size, int offset) {
        String hexRep = Long.toHexString(value).toUpperCase();
        int size_t = size;
        int hexRepOff = 0;
        do {
            if (hexRepOff < hexRep.length()) {
                charsAsBytes[offset + size - 1] = (byte)hexRep.charAt(hexRep.length() - hexRepOff - 1);
                ++hexRepOff;
                continue;
            }
            charsAsBytes[offset + size - 1] = 48;
        } while (--size > 0);
        return size_t + offset;
    }

    static final int kgrdc2ub(byte[] src, int src_offset, byte[] dst, int dst_offset, int length) throws SQLException {
        byte rowid_type = T4CRowidAccessor.getRowidType(src, src_offset);
        byte[] byte_rowid = dst;
        int bytes_to_convert = length - 1;
        int next_input_byte = 0;
        byte[] kgrd_char64_tosigned = kgrd_index_64;
        int byte_used_len = 1 + (3 * ((length - 1) / 4) + ((length - 1) % 4 != 0 ? (length - 1) % 4 - 1 : 0));
        if (bytes_to_convert == 0) {
            throw (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
        }
        byte_rowid[dst_offset + 0] = rowid_type;
        next_input_byte = src_offset + 1;
        int next_output_byte = 1;
        while (bytes_to_convert > 0) {
            byte byte_after_this;
            if (bytes_to_convert == 1) {
                throw (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
            }
            byte this_byte = kgrd_char64_tosigned[src[next_input_byte]];
            if (this_byte == -1) {
                throw (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
            }
            if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                throw (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
            }
            byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 0xFF) << 2 | (byte_after_this & 0x30) >> 4);
            if (bytes_to_convert == 2) break;
            ++next_output_byte;
            this_byte = byte_after_this;
            if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                throw (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
            }
            byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 0xFF) << 4 | (byte_after_this & 0x3C) >> 2);
            if (bytes_to_convert == 3) break;
            ++next_output_byte;
            this_byte = byte_after_this;
            if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                throw (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
            }
            byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 3) << 6 | byte_after_this);
            bytes_to_convert -= 4;
            ++next_input_byte;
            ++next_output_byte;
        }
        return byte_used_len;
    }

    static final long[] stringToRowid(byte[] data, int offset, int length) throws SQLException {
        int size = 18;
        if (length != size) {
            throw new SQLException("Rowid size incorrect.");
        }
        long[] ret = new long[4];
        try {
            ret[0] = T4CRowidAccessor.kgrdb42(data, 6, offset);
            ret[1] = T4CRowidAccessor.kgrdb42(data, 3, offset += 6);
            ret[2] = T4CRowidAccessor.kgrdb42(data, 6, offset += 3);
            ret[3] = T4CRowidAccessor.kgrdb42(data, 3, offset += 6);
            offset += 3;
        }
        catch (Exception e) {
            ret[0] = 0L;
            ret[1] = 0L;
            ret[2] = 0L;
            ret[3] = 0L;
        }
        return ret;
    }

    static final int kgrd42b(byte[] charsAsBytes, long value, int size, int offset) {
        int size_t = size;
        long val = value;
        while (size > 0) {
            charsAsBytes[offset + size - 1] = kgrd_basis_64[(int)val & 0x3F];
            val = val >>> 6 & 0x3FFFFFFL;
            --size;
        }
        return size_t + offset;
    }

    static final long kgrdb42(byte[] charsAsBytes, int size, int offset) throws SQLException {
        long ret = 0L;
        for (int i = 0; i < size; ++i) {
            byte value = charsAsBytes[offset + i];
            if ((value = kgrd_index_64[value]) == -1) {
                throw new SQLException("Char data to rowid conversion failed.");
            }
            ret <<= 6;
            ret |= (long)value;
        }
        return ret;
    }

    static final void kgrdr2ec(int tidrba, int tidpid, int tidtbl, int ridrba, int ridsqn, byte[] dstBytes, int dstOffset) throws SQLException {
        dstOffset = T4CRowidAccessor.kgrd42b(tidrba, dstBytes, dstOffset, 6);
        dstOffset = T4CRowidAccessor.kgrd42b(tidpid, dstBytes, dstOffset, 3);
        dstOffset = T4CRowidAccessor.kgrd42b(ridrba, dstBytes, dstOffset, 6);
        dstOffset = T4CRowidAccessor.kgrd42b(ridsqn, dstBytes, dstOffset, 3);
    }

    static final int kgrd42b(int value, byte[] dstBytes, int dstOffset, int digits) throws SQLException {
        int len = digits;
        while (digits > 0) {
            dstBytes[dstOffset + --digits] = kgrd_basis_64[value & 0x3F];
            value >>= 6;
        }
        return dstOffset + len;
    }

    static final int kgrdub2c(byte[] bytes, int size, int offset, byte[] dstBytes, int dstOffset) throws SQLException {
        int rid_length = -1;
        byte rid_type = bytes[offset];
        if (rid_type == 1) {
            int[] int_bytes = new int[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                int_bytes[i] = bytes[i] & 0xFF;
            }
            int temp = offset + 1;
            int tidrba = (((int_bytes[temp + 0] << 8) + int_bytes[temp + 1] << 8) + int_bytes[temp + 2] << 8) + int_bytes[temp + 3];
            temp = offset + 5;
            int tidpid = (int_bytes[temp + 0] << 8) + int_bytes[temp + 1];
            int tidtbl = 0;
            temp = offset + 7;
            int ridrba = (((int_bytes[temp + 0] << 8) + int_bytes[temp + 1] << 8) + int_bytes[temp + 2] << 8) + int_bytes[temp + 3];
            temp = offset + 11;
            int ridsqn = (int_bytes[temp + 0] << 8) + int_bytes[temp + 1];
            if (tidrba == 0) {
                T4CRowidAccessor.kgrdr2rc(tidrba, tidpid, tidtbl, ridrba, ridsqn, dstBytes, dstOffset);
            } else {
                T4CRowidAccessor.kgrdr2ec(tidrba, tidpid, tidtbl, ridrba, ridsqn, dstBytes, dstOffset);
            }
            rid_length = 18;
        } else {
            int next_output_byte = 0;
            int bytes_to_convert = size - 1;
            int body_length = 4 * (size / 3) + (size % 3 == 0 ? size % 3 + 1 : 0);
            int char_length = 1 + body_length - 1;
            if (char_length != 0) {
                dstBytes[dstOffset + 0] = kgrd_indbyte_char[rid_type - 1];
                int next_input_byte = offset + 1;
                next_output_byte = 1;
                byte second_byte = 0;
                while (bytes_to_convert > 0) {
                    dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 0xFF) >> 2];
                    if (bytes_to_convert == 1) {
                        dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 3) << 4];
                        break;
                    }
                    second_byte = (byte)(bytes[next_input_byte + 1] & 0xFF);
                    dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 3) << 4 | (second_byte & 0xF0) >> 4];
                    if (bytes_to_convert == 2) {
                        dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(second_byte & 0xF) << 2];
                        break;
                    }
                    dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(second_byte & 0xF) << 2 | (bytes[next_input_byte += 2] & 0xC0) >> 6];
                    dstBytes[dstOffset + next_output_byte] = kgrd_basis_64[bytes[next_input_byte] & 0x3F];
                    bytes_to_convert -= 3;
                    ++next_input_byte;
                    ++next_output_byte;
                }
            }
            rid_length = next_output_byte;
        }
        return rid_length;
    }

    static final byte[] rowidToDTYBURI(long[] rowid) {
        int tidrba = (int)rowid[0];
        int tidpid = (int)rowid[1];
        int ridrba = (int)rowid[2];
        int ridsqn = (int)rowid[3];
        int tidrbaOffset = 1;
        int tidpidOffset = tidrbaOffset + 4;
        int ridrbaOffset = tidpidOffset + 2;
        int ridsqnOffset = ridrbaOffset + 4;
        byte[] kd4ubrid = new byte[ridsqnOffset + 2];
        kd4ubrid[0] = 1;
        kd4ubrid[tidrbaOffset] = (byte)(tidrba >> 24 & 0xFF);
        kd4ubrid[tidrbaOffset + 1] = (byte)(tidrba >> 16 & 0xFF);
        kd4ubrid[tidrbaOffset + 2] = (byte)(tidrba >> 8 & 0xFF);
        kd4ubrid[tidrbaOffset + 3] = (byte)(tidrba & 0xFF);
        kd4ubrid[tidpidOffset] = (byte)(tidpid >> 8 & 0xFF);
        kd4ubrid[tidpidOffset + 1] = (byte)(tidpid & 0xFF);
        kd4ubrid[ridrbaOffset] = (byte)(ridrba >> 24 & 0xFF);
        kd4ubrid[ridrbaOffset + 1] = (byte)(ridrba >> 16 & 0xFF);
        kd4ubrid[ridrbaOffset + 2] = (byte)(ridrba >> 8 & 0xFF);
        kd4ubrid[ridrbaOffset + 3] = (byte)(ridrba & 0xFF);
        kd4ubrid[ridsqnOffset] = (byte)(ridsqn >> 8 & 0xFF);
        kd4ubrid[ridsqnOffset + 1] = (byte)(ridsqn & 0xFF);
        return kd4ubrid;
    }

    static final byte[] rowidToDTYBRI(long[] rowid, int sdbaOfBits, int sdbaBits, int dbabBits) {
        int tidrba = (int)rowid[0];
        int tidpid = (int)rowid[1];
        int ridrba = (int)rowid[2];
        int ridsqn = (int)rowid[3];
        int tidrbaOffset = 0;
        int krdbaOffset = 4;
        int ridsqnOffset = krdbaOffset + 4;
        byte[] kd4lbrid = new byte[ridsqnOffset + 2];
        kd4lbrid[tidrbaOffset] = (byte)(tidrba >> 24 & 0xFF);
        kd4lbrid[tidrbaOffset + 1] = (byte)(tidrba >> 16 & 0xFF);
        kd4lbrid[tidrbaOffset + 2] = (byte)(tidrba >> 8 & 0xFF);
        kd4lbrid[tidrbaOffset + 3] = (byte)(tidrba & 0xFF);
        int tidpidHi = tidpid >> sdbaOfBits;
        int tidpidLo = tidpid & (1 << sdbaOfBits) - 1;
        int krdba = ridrba + (tidpidHi << dbabBits | tidpidLo << sdbaBits - sdbaOfBits);
        kd4lbrid[krdbaOffset] = (byte)(krdba >> 24 & 0xFF);
        kd4lbrid[krdbaOffset + 1] = (byte)(krdba >> 16 & 0xFF);
        kd4lbrid[krdbaOffset + 2] = (byte)(krdba >> 8 & 0xFF);
        kd4lbrid[krdbaOffset + 3] = (byte)(krdba & 0xFF);
        kd4lbrid[ridsqnOffset] = (byte)(ridsqn >> 8 & 0xFF);
        kd4lbrid[ridsqnOffset + 1] = (byte)(ridsqn & 0xFF);
        return kd4lbrid;
    }

    static final boolean isRestricted(byte[] rowidChars) {
        for (int i = 0; i < rowidChars.length; ++i) {
            if (46 != rowidChars[i]) continue;
            return true;
        }
        return false;
    }

    static final boolean isUROWID(byte[] data, int offset) {
        return T4CRowidAccessor.getRowidType(data, offset) == 2;
    }

    static final byte getRowidType(byte[] data, int offset) {
        byte rowid_type = 5;
        switch (data[offset]) {
            case 65: {
                rowid_type = 1;
                break;
            }
            case 42: {
                rowid_type = 2;
                break;
            }
            case 45: {
                rowid_type = 3;
                break;
            }
            case 40: {
                rowid_type = 4;
                break;
            }
            case 41: {
                rowid_type = 5;
            }
        }
        return rowid_type;
    }
}

