/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.GlsRecord;
import com.dickimawbooks.bibgls.bib2gls.SupplementalRecord;
import com.dickimawbooks.texparserlib.TeXPath;

public class GlsSuppRecord
extends GlsRecord
implements SupplementalRecord {
    private TeXPath src;

    public GlsSuppRecord(Bib2Gls bib2Gls, String string, String string2, String string3, String string4, String string5, TeXPath teXPath) {
        super(bib2Gls, string, string2, string3, string4, string5);
        this.src = teXPath;
    }

    protected GlsSuppRecord(Bib2Gls bib2Gls, String string, String string2, String string3, String string4, String string5, TeXPath teXPath, long l) {
        super(bib2Gls, string, string2, string3, string4, string5, l);
        this.src = teXPath;
    }

    @Override
    public GlsRecord copy(String string) {
        return new GlsSuppRecord(this.bib2gls, string, this.getPrefix(), this.getCounter(), this.getFormat(), this.getLocation(), this.src, this.getIndex());
    }

    @Override
    public Object clone() {
        return new GlsSuppRecord(this.bib2gls, this.getLabel(), this.getPrefix(), this.getCounter(), this.getFormat(), this.getLocation(), this.src, this.getIndex());
    }

    @Override
    public TeXPath getSource() {
        return this.src;
    }

    @Override
    public String getFmtTeXCode(String string) {
        if (!this.bib2gls.isMultipleSupplementarySupported()) {
            return super.getFmtTeXCode(string);
        }
        String string2 = this.getFormat();
        if (string2.isEmpty()) {
            string2 = "glsnumberformat";
        } else if (string2.startsWith("(") || string2.startsWith(")")) {
            string2 = string2.length() == 1 ? "glsnumberformat" : string2.substring(1);
        }
        return String.format("\\glsxtrdisplaysupploc{%s}{%s}{%s}{%s}{%s}", this.getPrefix(), this.getCounter(), string2, this.bib2gls.getTeXPathHref(this.src), string);
    }

    @Override
    public boolean locationMatch(GlsRecord glsRecord) {
        if (!(glsRecord instanceof GlsSuppRecord)) {
            return false;
        }
        GlsSuppRecord glsSuppRecord = (GlsSuppRecord)glsRecord;
        if (!this.src.equals(glsSuppRecord.src)) {
            return false;
        }
        return super.locationMatch(glsRecord);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GlsSuppRecord) || !super.equals(object)) {
            return false;
        }
        return this.src.equals(((GlsSuppRecord)object).src);
    }

    @Override
    public boolean partialMatch(GlsRecord glsRecord) {
        if (!(glsRecord instanceof GlsSuppRecord) || !super.partialMatch(glsRecord)) {
            return false;
        }
        return this.src.equals(((GlsSuppRecord)glsRecord).src);
    }

    @Override
    public String toString() {
        return String.format("{%s}{%s}{%s}{%s}{%s}{%s}", this.getLabel(), this.getPrefix(), this.getCounter(), this.getFormat(), this.bib2gls.getTeXPathHref(this.src), this.getLocation());
    }
}

