/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth;

import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import tim.prune.function.filesleuth.AbstractFileScanner;
import tim.prune.function.filesleuth.FileScanner;
import tim.prune.function.filesleuth.TrackListListener;
import tim.prune.function.filesleuth.WorkerCoordinator;
import tim.prune.function.filesleuth.data.TrackContents;
import tim.prune.function.filesleuth.data.TrackFile;
import tim.prune.function.filesleuth.data.TrackFileList;
import tim.prune.function.filesleuth.data.TrackFileStatus;

public class ScanController
implements TrackListListener,
WorkerCoordinator {
    private final TrackFileList _trackList;
    private final TimeZone _timezone;
    private int _numCurrentWorkers = 0;
    private final LinkedList<AbstractFileScanner> _waitingScanners = new LinkedList();
    private ScannerCreator _scannerCreator = FileScanner::new;
    private static final int MAX_PARALLEL_SCANS = 10;

    public ScanController(TrackFileList trackFileList, TimeZone timeZone) {
        this._trackList = trackFileList;
        this._trackList.addListener(this);
        this._timezone = timeZone;
    }

    @Override
    public void reactToTrackListChange(int n) {
        List<TrackFile> list = this._trackList.getCurrentContents();
        int n2 = n;
        while (n2 < list.size()) {
            TrackFile trackFile = list.get(n2);
            if (trackFile.getStatus() == TrackFileStatus.FOUND && this._trackList.claimTrackFileForScanning(trackFile)) {
                this._waitingScanners.add(this._scannerCreator.createScanner(trackFile, this, this._timezone));
            }
            ++n2;
        }
        this.startWaitingScanners();
    }

    public synchronized void cancel() {
        this._waitingScanners.clear();
    }

    public synchronized void startWaitingScanners() {
        while (this._numCurrentWorkers < 10 && !this._waitingScanners.isEmpty()) {
            this._waitingScanners.pop().startScan();
            ++this._numCurrentWorkers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void informWorkComplete(TrackFile trackFile, TrackContents trackContents) {
        this._trackList.scanComplete(trackFile, trackContents);
        ScanController scanController = this;
        synchronized (scanController) {
            --this._numCurrentWorkers;
        }
        this.startWaitingScanners();
    }

    void setScannerCreator(ScannerCreator scannerCreator) {
        this._scannerCreator = scannerCreator;
    }

    static interface ScannerCreator {
        public AbstractFileScanner createScanner(TrackFile var1, WorkerCoordinator var2, TimeZone var3);
    }
}

