'use strict';

/*!
 * VisualEditor UserInterface MWReferenceResultWidget class.
 *
 * @copyright 2011-2018 VisualEditor Team's Cite sub-team and others; see AUTHORS.txt
 * @license MIT
 */

/**
 * Creates an ve.ui.MWReferenceResultWidget object.
 *
 * @constructor
 * @extends OO.ui.OptionWidget
 * @param {Object} config
 * @param {Object} config.item An item from the search index in ve.ui.MWReferenceSearchWidget
 * @param {ve.dm.MWReferenceModel} config.item.reference
 * @param {string} config.item.name
 * @param {string} config.item.footnoteLabel e.g. "note 1"
 * @param {OO.ui.Element} [config.reuseMenu]
 */
ve.ui.MWReferenceResultWidget = function VeUiMWReferenceResultWidget( config ) {
	config = ve.extendObject( {
		title: ve.msg( 'cite-ve-dialog-reference-useexisting-long-tool' )
	}, config );

	// Parent constructor
	ve.ui.MWReferenceResultWidget.super.apply( this, arguments );

	// Initialization
	const item = config.item;

	this.$element
		.addClass( 've-ui-mwReferenceResultWidget' );
	if ( item.reference.extendsRef ) {
		this.$element.addClass( 've-ui-mwReferenceResultWidget-sub' );
	}

	const $footnoteLabel = $( '<div>' )
		.addClass( 've-ui-mwReferenceResultWidget-footnote' )
		.text( '[' + item.footnoteLabel + ']' );

	const $name = $( '<div>' )
		.addClass( 've-ui-mwReferenceResultWidget-name' )
		.toggleClass( 've-ui-mwReferenceResultWidget-name-autogenerated', /^:\d+$/.test( item.name ) )
		.text( item.name );

	this.setLabel( $footnoteLabel.add( $name ).add( item.$refContent ) );
	this.setData( item.reference );

	if ( mw.config.get( 'wgCiteSubReferencing' ) && config.reuseMenu ) {
		this.$element.append( config.reuseMenu.$element );
	}
};

/* Inheritance */

OO.inheritClass( ve.ui.MWReferenceResultWidget, OO.ui.OptionWidget );
