/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ExtensibleDigest {
    private ExtensibleDigest() {
    }

    public static byte[] encode(byte[] clientNonce, byte[] password, byte[] salt, String algoName, byte[] serverNonce) {
        byte[] passDigest;
        try {
            MessageDigest md = MessageDigest.getInstance(algoName);
            md.update(password);
            md.update(salt);
            passDigest = md.digest();
            md = MessageDigest.getInstance(algoName);
            md.update(passDigest);
            md.update(serverNonce);
            md.update(clientNonce);
            passDigest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to encode password with extensible hashing:" + algoName, e);
        }
        return passDigest;
    }
}

