/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.extern.decimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Locale;
import java.util.Objects;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal32;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.extern.decimal.DecimalCodec;
import org.firebirdsql.extern.decimal.DecimalFactory;
import org.firebirdsql.extern.decimal.DecimalFormat;
import org.firebirdsql.extern.decimal.DecimalInconvertibleException;
import org.firebirdsql.extern.decimal.DecimalType;
import org.firebirdsql.extern.decimal.OverflowHandling;

public abstract class Decimal<T extends Decimal<T>> {
    private final int signum;
    private final DecimalType type;
    private final BigDecimal bigDecimal;

    Decimal(int signum, DecimalType type) {
        assert (type != null) : "Type should not be null";
        assert (type != DecimalType.FINITE) : "Constructor only suitable for non-FINITE";
        assert (-1 == signum || signum == 1) : "Invalid signum, " + signum;
        this.signum = signum;
        this.type = type;
        this.bigDecimal = null;
    }

    Decimal(int signum, BigDecimal bigDecimal) {
        assert (-1 <= signum && signum <= 1) : "Invalid signum, " + signum;
        this.type = DecimalType.FINITE;
        this.signum = signum != 0 ? signum : 1;
        this.bigDecimal = Objects.requireNonNull(bigDecimal, "bigDecimal");
        if (bigDecimal.compareTo(BigDecimal.ZERO) != 0 && this.signum != bigDecimal.signum()) {
            throw new IllegalArgumentException("Signum value not consistent with big decimal value, was: " + signum + ", expected: " + bigDecimal.signum());
        }
    }

    public final BigDecimal toBigDecimal() {
        if (this.type != DecimalType.FINITE) {
            throw new DecimalInconvertibleException("Value " + this + " cannot be converted to a BigDecimal", this.type, this.signum);
        }
        return this.bigDecimal;
    }

    public final double doubleValue() {
        switch (this.type) {
            case FINITE: {
                return this.bigDecimal.doubleValue();
            }
            case INFINITY: {
                return this.signum == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            case NAN: 
            case SIGNALING_NAN: {
                return Double.NaN;
            }
        }
        throw new IllegalStateException("Unsupported DecimalType " + (Object)((Object)this.type));
    }

    public final byte[] toBytes() {
        return this.getDecimalCodec().encodeDecimal(this);
    }

    public final <D extends Decimal<D>> D toDecimal(Class<D> decimalType) {
        return this.toDecimal(decimalType, OverflowHandling.ROUND_TO_INFINITY);
    }

    public final <D extends Decimal<D>> D toDecimal(Class<D> decimalType, OverflowHandling overflowHandling) {
        if (decimalType == this.getClass()) {
            return (D)((Decimal)decimalType.cast(this));
        }
        if (decimalType == Decimal128.class) {
            return (D)((Decimal)decimalType.cast(Decimal128.valueOf(this, overflowHandling)));
        }
        if (decimalType == Decimal64.class) {
            return (D)((Decimal)decimalType.cast(Decimal64.valueOf(this, overflowHandling)));
        }
        if (decimalType == Decimal32.class) {
            return (D)((Decimal)decimalType.cast(Decimal32.valueOf(this, overflowHandling)));
        }
        throw new IllegalArgumentException("Unsupported conversion to " + decimalType.getName());
    }

    final DecimalType getType() {
        return this.type;
    }

    final int signum() {
        return this.signum;
    }

    final boolean isEquivalentToZero() {
        return this.type == DecimalType.FINITE && BigDecimal.ZERO.compareTo(this.bigDecimal) == 0;
    }

    abstract DecimalCodec<T> getDecimalCodec();

    abstract DecimalFactory<T> getDecimalFactory();

    final T negate() {
        DecimalFactory<T> decimalFactory = this.getDecimalFactory();
        if (this.type != DecimalType.FINITE) {
            return (T)((Decimal)decimalFactory.getSpecialConstant(-1 * this.signum, this.type));
        }
        return (T)((Decimal)decimalFactory.createDecimal(-1 * this.signum, this.bigDecimal.negate()));
    }

    public final String toString() {
        switch (this.type) {
            case FINITE: {
                if (this.signum == -1 && this.isEquivalentToZero()) {
                    return "-" + this.bigDecimal.toString();
                }
                return this.bigDecimal.toString();
            }
            case INFINITY: {
                return this.signum == -1 ? "-Infinity" : "+Infinity";
            }
            case NAN: {
                return this.signum == -1 ? "-NaN" : "+NaN";
            }
            case SIGNALING_NAN: {
                return this.signum == -1 ? "-sNaN" : "+sNaN";
            }
        }
        throw new IllegalStateException("Unsupported DecimalType " + (Object)((Object)this.type));
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decimal decimal = (Decimal)o;
        if (this.signum != decimal.signum) {
            return false;
        }
        if (this.type != decimal.type) {
            return false;
        }
        return Objects.equals(this.bigDecimal, decimal.bigDecimal);
    }

    public final int hashCode() {
        int result = this.signum;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.bigDecimal != null ? this.bigDecimal.hashCode() : 0);
        return result;
    }

    static abstract class AbstractDecimalFactory<T extends Decimal<T>>
    implements DecimalFactory<T> {
        private final Class<T> type;
        private final DecimalFormat decimalFormat;
        private final T positiveInfinity;
        private final T negativeInfinity;
        private final T positiveNan;
        private final T negativeNan;
        private final T positiveSignalingNaN;
        private final T negativeSignalingNaN;

        AbstractDecimalFactory(Class<T> type, DecimalFormat decimalFormat, T positiveInfinity, T negativeInfinity, T positiveNan, T negativeNan, T positiveSignalingNaN, T negativeSignalingNaN) {
            this.type = type;
            this.decimalFormat = decimalFormat;
            this.positiveInfinity = positiveInfinity;
            this.negativeInfinity = negativeInfinity;
            this.positiveNan = positiveNan;
            this.negativeNan = negativeNan;
            this.positiveSignalingNaN = positiveSignalingNaN;
            this.negativeSignalingNaN = negativeSignalingNaN;
        }

        @Override
        public final DecimalFormat getDecimalFormat() {
            return this.decimalFormat;
        }

        private MathContext getMathContext() {
            return this.decimalFormat.getMathContext();
        }

        final BigDecimal validateRange(BigDecimal value) {
            return this.decimalFormat.validate(value);
        }

        final T valueOf(BigDecimal value, OverflowHandling overflowHandling) {
            BigDecimal roundedValue = this.decimalFormat.tryRound(value);
            if (overflowHandling == OverflowHandling.ROUND_TO_INFINITY && this.decimalFormat.isOutOfRange(roundedValue)) {
                return (T)this.getSpecialConstant(roundedValue.signum(), DecimalType.INFINITY);
            }
            return (T)((Decimal)this.createDecimal(value.signum(), roundedValue));
        }

        final T valueOf(BigInteger value, OverflowHandling overflowHandling) {
            return this.valueOf(new BigDecimal(value, this.getMathContext()), overflowHandling);
        }

        final T valueOfExact(BigInteger value) {
            BigDecimal bigDecimal = new BigDecimal(this.decimalFormat.validateCoefficient(value));
            return (T)((Decimal)this.createDecimal(value.signum(), bigDecimal));
        }

        final T valueOf(double value, OverflowHandling overflowHandling) {
            if (Double.isNaN(value)) {
                return (T)this.getSpecialConstant(1, DecimalType.NAN);
            }
            if (value == Double.POSITIVE_INFINITY) {
                return (T)this.getSpecialConstant(1, DecimalType.INFINITY);
            }
            if (value == Double.NEGATIVE_INFINITY) {
                return (T)this.getSpecialConstant(-1, DecimalType.INFINITY);
            }
            return this.valueOf(new BigDecimal(Double.toString(value), this.getMathContext()), overflowHandling);
        }

        final T valueOf(Decimal<?> decimal, OverflowHandling overflowHandling) {
            if (decimal.getClass() == this.type) {
                return (T)((Decimal)this.type.cast(decimal));
            }
            if (((Decimal)decimal).type == DecimalType.FINITE) {
                return this.valueOf(((Decimal)decimal).bigDecimal, overflowHandling);
            }
            return (T)this.getSpecialConstant(((Decimal)decimal).signum, ((Decimal)decimal).type);
        }

        final T valueOf(String value, OverflowHandling overflowHandling) {
            BigDecimal bdValue;
            T decimalValue;
            if (value.length() > 2) {
                char checkChar = value.charAt(0);
                if (checkChar == '+' || checkChar == '-') {
                    checkChar = value.charAt(1);
                }
                if (checkChar == 'i' || checkChar == 'I' || checkChar == 'n' || checkChar == 'N' || checkChar == 's' || checkChar == 'S') {
                    return this.valueOfSpecial(value);
                }
            }
            if (((Decimal)(decimalValue = this.valueOf(bdValue = new BigDecimal(value, this.getMathContext()), overflowHandling))).isEquivalentToZero() && value.charAt(0) == '-' && bdValue.signum() != -1) {
                return ((Decimal)decimalValue).negate();
            }
            return decimalValue;
        }

        private T valueOfSpecial(String special) {
            switch (special.toLowerCase(Locale.ROOT)) {
                case "inf": 
                case "infinity": 
                case "+inf": 
                case "+infinity": {
                    return (T)this.getSpecialConstant(1, DecimalType.INFINITY);
                }
                case "-inf": 
                case "-infinity": {
                    return (T)this.getSpecialConstant(-1, DecimalType.INFINITY);
                }
                case "nan": 
                case "+nan": {
                    return (T)this.getSpecialConstant(1, DecimalType.NAN);
                }
                case "-nan": {
                    return (T)this.getSpecialConstant(-1, DecimalType.NAN);
                }
                case "snan": 
                case "+snan": {
                    return (T)this.getSpecialConstant(1, DecimalType.SIGNALING_NAN);
                }
                case "-snan": {
                    return (T)this.getSpecialConstant(-1, DecimalType.SIGNALING_NAN);
                }
            }
            throw new NumberFormatException("Invalid value " + special);
        }

        @Override
        public final T getSpecialConstant(int signum, DecimalType decimalType) {
            switch (decimalType) {
                case INFINITY: {
                    return signum == -1 ? this.negativeInfinity : this.positiveInfinity;
                }
                case NAN: {
                    return signum == -1 ? this.negativeNan : this.positiveNan;
                }
                case SIGNALING_NAN: {
                    return signum == -1 ? this.negativeSignalingNaN : this.positiveSignalingNaN;
                }
            }
            throw new AssertionError((Object)("Invalid special value for decimalType " + (Object)((Object)decimalType)));
        }
    }
}

