/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PyLongFromUnicodeObjectNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;

@GenerateInline(inlineByDefault=true)
@GenerateUncached
public abstract class PyLongFromUnicodeObject
extends Node {
    public final Object execute(Node inliningTarget, Object string, int base) {
        return this.execute(inliningTarget, string, base, null, 0);
    }

    public abstract Object execute(Node var1, Object var2, int var3, byte[] var4, int var5);

    public final Object executeCached(Object string, int base) {
        return this.execute(null, string, base);
    }

    public static Object executeUncached(Object string, int base) {
        return PyLongFromUnicodeObjectNodeGen.getUncached().execute(null, string, base);
    }

    @Specialization
    static Object doString(Node inliningTarget, Object stringObj, int base, byte[] originalBytes, int originalBytesLen, @Cached CastToTruffleStringNode cast, @Cached TruffleString.ParseLongNode parseLongNode, @Cached InlinedConditionProfile intOrLongResult, @Cached GenericIntParserNode genericParser) {
        TruffleString string = cast.castKnownString(inliningTarget, stringObj);
        if (base == 10) {
            try {
                long result = parseLongNode.execute((AbstractTruffleString)string, 10);
                if (intOrLongResult.profile(inliningTarget, PInt.isIntRange(result))) {
                    return (int)result;
                }
                return result;
            }
            catch (TruffleString.NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return PyLongFromUnicodeObject.parseGeneric(string, base, originalBytes, originalBytesLen, genericParser);
    }

    @HostCompilerDirectives.InliningCutoff
    private static Object parseGeneric(TruffleString string, int base, byte[] originalBytes, int originalBytesLen, GenericIntParserNode fromString) {
        return fromString.execute(string, base, originalBytes, originalBytesLen);
    }

    @NeverDefault
    public static PyLongFromUnicodeObject create() {
        return PyLongFromUnicodeObjectNodeGen.create();
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class GenericIntParserNode
    extends Node {
        GenericIntParserNode() {
        }

        public abstract Object execute(TruffleString var1, int var2, byte[] var3, int var4);

        @Specialization
        static Object doGeneric(TruffleString numberTs, int base, byte[] originalBytes, int originalBytesLen, @Bind Node inliningTarget, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached InlinedBranchProfile invalidBase, @Cached InlinedBranchProfile notSimpleDecimalLiteralProfile, @Cached InlinedBranchProfile invalidValueProfile, @Cached PRaiseNode raiseNode, @Cached StringNodes.StringReprNode stringReprNode, @Cached BytesNodes.BytesReprNode bytesReprNode) {
            String number = toJavaStringNode.execute((AbstractTruffleString)numberTs);
            if (base != 0 && base < 2 || base > 36) {
                invalidBase.enter(inliningTarget);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INT_BASE_MUST_BE_2_AND_36_OR_0);
            }
            notSimpleDecimalLiteralProfile.enter(inliningTarget);
            PythonContext context = PythonContext.get(inliningTarget);
            Object value = GenericIntParserNode.stringToIntInternal(inliningTarget, number, base, context);
            if (value == null) {
                invalidValueProfile.enter(inliningTarget);
                TruffleString repr = originalBytes == null ? stringReprNode.execute(numberTs) : bytesReprNode.execute(inliningTarget, PFactory.createBytes(context.getLanguage(inliningTarget), originalBytes, originalBytesLen));
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_LITERAL_FOR_INT_WITH_BASE, base, repr);
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object stringToIntInternal(Node inliningTarget, String num, int base, PythonContext context) {
            try {
                BigInteger bi = GenericIntParserNode.asciiToBigInteger(inliningTarget, num, base, context);
                if (bi == null) {
                    return null;
                }
                if (bi.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || bi.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
                    return PFactory.createInt(context.getLanguage(), bi);
                }
                return bi.intValue();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger asciiToBigInteger(Node inliningTarget, String str, int possibleBase, PythonContext context) throws NumberFormatException {
            int b;
            int base = possibleBase;
            int e = str.length();
            for (b = 0; b < e && Character.isWhitespace(str.charAt(b)); ++b) {
            }
            while (e > b && Character.isWhitespace(str.charAt(e - 1))) {
                --e;
            }
            boolean acceptUnderscore = false;
            boolean raiseIfNotZero = false;
            char sign = '\u0000';
            if (b < e) {
                sign = str.charAt(b);
                if (sign == '-' || sign == '+') {
                    ++b;
                }
                if (b < e && str.charAt(b) == '0') {
                    int next;
                    int n = next = b + 1 < e ? (int)Character.toUpperCase(str.charAt(b + 1)) : 63;
                    if (base == 0) {
                        if (next == 88) {
                            base = 16;
                        } else if (next == 79) {
                            base = 8;
                        } else if (next == 66) {
                            base = 2;
                        } else {
                            raiseIfNotZero = true;
                        }
                    }
                    if (base == 16 && next == 88 || base == 8 && next == 79 || base == 2 && next == 66) {
                        b += 2;
                        acceptUnderscore = true;
                    }
                }
            }
            if (base == 0) {
                base = 10;
            }
            for (int i = b; i < e; ++i) {
                char c = str.charAt(i);
                if (c == '_') {
                    if (!acceptUnderscore || i == e - 1) {
                        throw new NumberFormatException("Illegal underscore in int literal");
                    }
                    acceptUnderscore = false;
                    continue;
                }
                acceptUnderscore = true;
                if (Character.digit(c, base) != -1) continue;
                return null;
            }
            String s = str;
            if (b > 0 || e < str.length()) {
                s = str.substring(b, e);
            }
            s = s.replace("_", "");
            GenericIntParserNode.checkMaxDigits(inliningTarget, context, s.length(), base);
            BigInteger bi = sign == '-' ? new BigInteger("-" + s, base) : new BigInteger(s, base);
            if (raiseIfNotZero && !bi.equals(BigInteger.ZERO)) {
                throw new NumberFormatException("Obsolete octal int literal");
            }
            return bi;
        }

        private static void checkMaxDigits(Node inliningTarget, PythonContext context, int digits, int base) {
            int maxDigits;
            if (digits > 640 && Integer.bitCount(base) != 1 && (maxDigits = context.getIntMaxStrDigits()) > 0 && digits > maxDigits) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.EXCEEDS_THE_LIMIT_FOR_INTEGER_STRING_CONVERSION_D, maxDigits, digits);
            }
        }
    }
}

