/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.util;

import java.io.Serializable;
import java.util.Objects;

public class Separators
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROOT_VALUE_SEPARATOR = " ";
    public static final String DEFAULT_OBJECT_EMPTY_SEPARATOR = " ";
    public static final String DEFAULT_ARRAY_EMPTY_SEPARATOR = " ";
    private final char objectNameValueSeparator;
    private final Spacing objectNameValueSpacing;
    private final char objectEntrySeparator;
    private final Spacing objectEntrySpacing;
    private final String objectEmptySeparator;
    private final char arrayElementSeparator;
    private final Spacing arrayElementSpacing;
    private final String arrayEmptySeparator;
    private final String rootSeparator;

    public static Separators createDefaultInstance() {
        return new Separators();
    }

    public Separators() {
        this(':', ',', ',');
    }

    public Separators(char objectNameValueSeparator, char objectEntrySeparator, char arrayElementSeparator) {
        this(" ", objectNameValueSeparator, Spacing.BOTH, objectEntrySeparator, Spacing.NONE, " ", arrayElementSeparator, Spacing.NONE, " ");
    }

    public Separators(String rootSeparator, char objectNameValueSeparator, Spacing objectNameValueSpacing, char objectEntrySeparator, Spacing objectEntrySpacing, String objectEmptySeparator, char arrayElementSeparator, Spacing arrayElementSpacing, String arrayEmptySeparator) {
        this.rootSeparator = rootSeparator;
        this.objectNameValueSeparator = objectNameValueSeparator;
        this.objectNameValueSpacing = objectNameValueSpacing;
        this.objectEntrySeparator = objectEntrySeparator;
        this.objectEntrySpacing = objectEntrySpacing;
        this.objectEmptySeparator = objectEmptySeparator;
        this.arrayElementSeparator = arrayElementSeparator;
        this.arrayElementSpacing = arrayElementSpacing;
        this.arrayEmptySeparator = arrayEmptySeparator;
    }

    public Separators withRootSeparator(String sep) {
        return Objects.equals(this.rootSeparator, sep) ? this : new Separators(sep, this.objectNameValueSeparator, this.objectNameValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayElementSeparator, this.arrayElementSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectNameValueSeparator(char sep) {
        return this.objectNameValueSeparator == sep ? this : new Separators(this.rootSeparator, sep, this.objectNameValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayElementSeparator, this.arrayElementSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectNameValueSpacing(Spacing spacing) {
        return this.objectNameValueSpacing == spacing ? this : new Separators(this.rootSeparator, this.objectNameValueSeparator, spacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayElementSeparator, this.arrayElementSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectEntrySeparator(char sep) {
        return this.objectEntrySeparator == sep ? this : new Separators(this.rootSeparator, this.objectNameValueSeparator, this.objectNameValueSpacing, sep, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayElementSeparator, this.arrayElementSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectEntrySpacing(Spacing spacing) {
        return this.objectEntrySpacing == spacing ? this : new Separators(this.rootSeparator, this.objectNameValueSeparator, this.objectNameValueSpacing, this.objectEntrySeparator, spacing, this.objectEmptySeparator, this.arrayElementSeparator, this.arrayElementSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectEmptySeparator(String sep) {
        return Objects.equals(this.objectEmptySeparator, sep) ? this : new Separators(this.rootSeparator, this.objectNameValueSeparator, this.objectNameValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, sep, this.arrayElementSeparator, this.arrayElementSpacing, this.arrayEmptySeparator);
    }

    public Separators withArrayElementSeparator(char sep) {
        return this.arrayElementSeparator == sep ? this : new Separators(this.rootSeparator, this.objectNameValueSeparator, this.objectNameValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, sep, this.arrayElementSpacing, this.arrayEmptySeparator);
    }

    public Separators withArrayElementSpacing(Spacing spacing) {
        return this.arrayElementSpacing == spacing ? this : new Separators(this.rootSeparator, this.objectNameValueSeparator, this.objectNameValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayElementSeparator, spacing, this.arrayEmptySeparator);
    }

    public Separators withArrayEmptySeparator(String sep) {
        return Objects.equals(this.arrayEmptySeparator, sep) ? this : new Separators(this.rootSeparator, this.objectNameValueSeparator, this.objectNameValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayElementSeparator, this.arrayElementSpacing, sep);
    }

    public String getRootSeparator() {
        return this.rootSeparator;
    }

    public char getObjectNameValueSeparator() {
        return this.objectNameValueSeparator;
    }

    public Spacing getObjectNameValueSpacing() {
        return this.objectNameValueSpacing;
    }

    public char getObjectEntrySeparator() {
        return this.objectEntrySeparator;
    }

    public Spacing getObjectEntrySpacing() {
        return this.objectEntrySpacing;
    }

    public String getObjectEmptySeparator() {
        return this.objectEmptySeparator;
    }

    public char getArrayElementSeparator() {
        return this.arrayElementSeparator;
    }

    public Spacing getArrayElementSpacing() {
        return this.arrayElementSpacing;
    }

    public String getArrayEmptySeparator() {
        return this.arrayEmptySeparator;
    }

    public static enum Spacing {
        NONE("", ""),
        BEFORE(" ", ""),
        AFTER("", " "),
        BOTH(" ", " ");

        private final String spacesBefore;
        private final String spacesAfter;

        private Spacing(String spacesBefore, String spacesAfter) {
            this.spacesBefore = spacesBefore;
            this.spacesAfter = spacesAfter;
        }

        public String spacesBefore() {
            return this.spacesBefore;
        }

        public String spacesAfter() {
            return this.spacesAfter;
        }

        public String apply(char separator) {
            return this.spacesBefore + separator + this.spacesAfter;
        }
    }
}

