# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._endpoints_operations import build_create_or_update_request, build_delete_request, build_get_request, build_update_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class EndpointsOperations:
    """EndpointsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.trafficmanager.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        profile_name: str,
        endpoint_type: Union[str, "_models.EndpointType"],
        endpoint_name: str,
        parameters: "_models.Endpoint",
        **kwargs: Any
    ) -> "_models.Endpoint":
        """Update a Traffic Manager endpoint.

        :param resource_group_name: The name of the resource group containing the Traffic Manager
         endpoint to be updated.
        :type resource_group_name: str
        :param profile_name: The name of the Traffic Manager profile.
        :type profile_name: str
        :param endpoint_type: The type of the Traffic Manager endpoint to be updated.
        :type endpoint_type: str or ~azure.mgmt.trafficmanager.models.EndpointType
        :param endpoint_name: The name of the Traffic Manager endpoint to be updated.
        :type endpoint_name: str
        :param parameters: The Traffic Manager endpoint parameters supplied to the Update operation.
        :type parameters: ~azure.mgmt.trafficmanager.models.Endpoint
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Endpoint, or the result of cls(response)
        :rtype: ~azure.mgmt.trafficmanager.models.Endpoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Endpoint"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Endpoint')

        request = build_update_request(
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            endpoint_type=endpoint_type,
            endpoint_name=endpoint_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Endpoint', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}'}  # type: ignore


    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        profile_name: str,
        endpoint_type: Union[str, "_models.EndpointType"],
        endpoint_name: str,
        **kwargs: Any
    ) -> "_models.Endpoint":
        """Gets a Traffic Manager endpoint.

        :param resource_group_name: The name of the resource group containing the Traffic Manager
         endpoint.
        :type resource_group_name: str
        :param profile_name: The name of the Traffic Manager profile.
        :type profile_name: str
        :param endpoint_type: The type of the Traffic Manager endpoint.
        :type endpoint_type: str or ~azure.mgmt.trafficmanager.models.EndpointType
        :param endpoint_name: The name of the Traffic Manager endpoint.
        :type endpoint_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Endpoint, or the result of cls(response)
        :rtype: ~azure.mgmt.trafficmanager.models.Endpoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Endpoint"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_request(
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            endpoint_type=endpoint_type,
            endpoint_name=endpoint_name,
            subscription_id=self._config.subscription_id,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Endpoint', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}'}  # type: ignore


    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        profile_name: str,
        endpoint_type: Union[str, "_models.EndpointType"],
        endpoint_name: str,
        parameters: "_models.Endpoint",
        **kwargs: Any
    ) -> "_models.Endpoint":
        """Create or update a Traffic Manager endpoint.

        :param resource_group_name: The name of the resource group containing the Traffic Manager
         endpoint to be created or updated.
        :type resource_group_name: str
        :param profile_name: The name of the Traffic Manager profile.
        :type profile_name: str
        :param endpoint_type: The type of the Traffic Manager endpoint to be created or updated.
        :type endpoint_type: str or ~azure.mgmt.trafficmanager.models.EndpointType
        :param endpoint_name: The name of the Traffic Manager endpoint to be created or updated.
        :type endpoint_name: str
        :param parameters: The Traffic Manager endpoint parameters supplied to the CreateOrUpdate
         operation.
        :type parameters: ~azure.mgmt.trafficmanager.models.Endpoint
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Endpoint, or the result of cls(response)
        :rtype: ~azure.mgmt.trafficmanager.models.Endpoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Endpoint"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Endpoint')

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            endpoint_type=endpoint_type,
            endpoint_name=endpoint_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.create_or_update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('Endpoint', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('Endpoint', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}'}  # type: ignore


    @distributed_trace_async
    async def delete(
        self,
        resource_group_name: str,
        profile_name: str,
        endpoint_type: Union[str, "_models.EndpointType"],
        endpoint_name: str,
        **kwargs: Any
    ) -> Optional["_models.DeleteOperationResult"]:
        """Deletes a Traffic Manager endpoint.

        :param resource_group_name: The name of the resource group containing the Traffic Manager
         endpoint to be deleted.
        :type resource_group_name: str
        :param profile_name: The name of the Traffic Manager profile.
        :type profile_name: str
        :param endpoint_type: The type of the Traffic Manager endpoint to be deleted.
        :type endpoint_type: str or ~azure.mgmt.trafficmanager.models.EndpointType
        :param endpoint_name: The name of the Traffic Manager endpoint to be deleted.
        :type endpoint_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeleteOperationResult, or the result of cls(response)
        :rtype: ~azure.mgmt.trafficmanager.models.DeleteOperationResult or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.DeleteOperationResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_request(
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            endpoint_type=endpoint_type,
            endpoint_name=endpoint_name,
            subscription_id=self._config.subscription_id,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeleteOperationResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}'}  # type: ignore

