/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveSecurityContext;
import io.quarkus.resteasy.reactive.server.runtime.security.SecurityContextOverrideHandler;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.runtime.ForwardedInfo;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.handlers.AbortChainHandler;
import org.jboss.resteasy.reactive.server.handlers.BlockingHandler;
import org.jboss.resteasy.reactive.server.handlers.ClassRoutingHandler;
import org.jboss.resteasy.reactive.server.handlers.FixedProducesHandler;
import org.jboss.resteasy.reactive.server.handlers.InputHandler;
import org.jboss.resteasy.reactive.server.handlers.InstanceHandler;
import org.jboss.resteasy.reactive.server.handlers.InvocationHandler;
import org.jboss.resteasy.reactive.server.handlers.MatrixParamHandler;
import org.jboss.resteasy.reactive.server.handlers.NonBlockingHandler;
import org.jboss.resteasy.reactive.server.handlers.ParameterHandler;
import org.jboss.resteasy.reactive.server.handlers.RequestDeserializeHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceRequestFilterHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.vertx.VertxResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class QuarkusResteasyReactiveRequestContext
extends VertxResteasyReactiveRequestContext {
    final CurrentIdentityAssociation association;
    boolean userSetup = false;

    public QuarkusResteasyReactiveRequestContext(Deployment deployment, RoutingContext context, ThreadSetupAction requestContext, ServerRestHandler[] handlerChain, ServerRestHandler[] abortHandlerChain, ClassLoader devModeTccl, CurrentIdentityAssociation currentIdentityAssociation) {
        super(deployment, context, requestContext, handlerChain, abortHandlerChain, devModeTccl);
        this.association = currentIdentityAssociation;
        if (VertxContext.isOnDuplicatedContext()) {
            VertxContextSafetyToggle.setCurrentContextSafe((boolean)true);
        }
    }

    protected void handleRequestScopeActivation() {
        super.handleRequestScopeActivation();
        if (!this.userSetup && this.association != null) {
            this.userSetup = true;
            QuarkusHttpUser existing = (QuarkusHttpUser)this.context.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.association.setIdentity(identity);
            } else {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)this.context, null));
            }
        }
    }

    protected void requestScopeDeactivated() {
    }

    protected SecurityContext createSecurityContext() {
        return new ResteasyReactiveSecurityContext(this.context);
    }

    protected void handleUnrecoverableError(Throwable throwable) {
        this.context.fail(this.effectiveThrowableForQuarkusLogging(throwable));
        this.endResponse();
    }

    private Throwable effectiveThrowableForQuarkusLogging(Throwable throwable) {
        if (!(throwable instanceof IOException)) {
            return throwable;
        }
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        boolean convertException = false;
        for (int depth = 0; depth < stackTrace.length && depth < 5; ++depth) {
            StackTraceElement stackTraceElement = stackTrace[depth];
            String className = stackTraceElement.getClassName();
            if (!className.contains(InvocationHandler.class.getSimpleName()) && !className.contains(ResourceRequestFilterHandler.class.getSimpleName())) continue;
            convertException = true;
            break;
        }
        return convertException ? new UncheckedIOException((IOException)throwable) : throwable;
    }

    public boolean handlesUnmappedException() {
        return false;
    }

    public void handleUnmappedException(Throwable throwable) {
        throw this.sneakyThrow(throwable);
    }

    public org.jboss.resteasy.reactive.server.spi.ForwardedInfo getForwardedInfo() {
        final ForwardedInfo vertxForwardedInfo = (ForwardedInfo)((HttpServerRequestInternal)this.request).context().getLocal((Object)ForwardedInfo.CONTEXT_KEY);
        if (vertxForwardedInfo == null) {
            return null;
        }
        return new org.jboss.resteasy.reactive.server.spi.ForwardedInfo(){

            public String getScheme() {
                return vertxForwardedInfo.getScheme();
            }

            public String getHost() {
                return vertxForwardedInfo.getHost();
            }

            public Integer getPort() {
                return vertxForwardedInfo.getPort();
            }

            public String getRemoteHost() {
                return vertxForwardedInfo.getRemoteHost();
            }

            public Integer getRemotePort() {
                return vertxForwardedInfo.getRemotePort();
            }

            public String getPrefix() {
                return vertxForwardedInfo.getPrefix();
            }
        };
    }

    private <E extends Throwable> RuntimeException sneakyThrow(Throwable e) throws E {
        throw e;
    }

    protected void invokeHandler(int pos) throws Exception {
        ServerRestHandler handler = ((ServerRestHandler[])this.handlers)[pos];
        if (handler instanceof MatrixParamHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof SecurityContextOverrideHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof RestInitialHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof ClassRoutingHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof AbortChainHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof NonBlockingHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof BlockingHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof ResourceRequestFilterHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof InputHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof RequestDeserializeHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof ParameterHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof InstanceHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof InvocationHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof FixedProducesHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof ResponseHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else if (handler instanceof ResponseWriterHandler) {
            handler.handle((ResteasyReactiveRequestContext)this);
        } else {
            handler.handle((ResteasyReactiveRequestContext)this);
        }
    }
}

