/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.Locale;

enum AuthenticationScheme {
    nativeAuthentication,
    ntlm,
    javaKerberos;


    static AuthenticationScheme valueOfString(String value) throws SQLServerException {
        AuthenticationScheme scheme;
        if (value.toLowerCase(Locale.US).equalsIgnoreCase(javaKerberos.toString())) {
            scheme = javaKerberos;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(nativeAuthentication.toString())) {
            scheme = nativeAuthentication;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(ntlm.toString())) {
            scheme = ntlm;
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidAuthenticationScheme"));
            Object[] msgArgs = new Object[]{value};
            throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
        }
        return scheme;
    }
}

