/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import java.math.BigInteger;

public class DafnyEuclidean {
    public static byte EuclideanDivision(byte a, byte b) {
        assert (b != 0) : "Precondition Failure";
        return (byte)DafnyEuclidean.EuclideanDivision((int)a, (int)b);
    }

    public static short EuclideanDivision(short a, short b) {
        assert (b != 0) : "Precondition Failure";
        return (short)DafnyEuclidean.EuclideanDivision((int)a, (int)b);
    }

    public static int EuclideanDivision(int a, int b) {
        assert (b != 0) : "Precondition Failure";
        if (0 <= a) {
            if (0 <= b) {
                return a / b;
            }
            if (b == Integer.MIN_VALUE) {
                return Integer.divideUnsigned(a, Integer.MIN_VALUE) * -1;
            }
            return -(a / -b);
        }
        if (0 <= b) {
            return -(-(a + 1) / b) - 1;
        }
        if (b == Integer.MIN_VALUE) {
            return Integer.divideUnsigned(-(a + 1), Integer.MIN_VALUE) + 1;
        }
        return -(a + 1) / -b + 1;
    }

    public static long EuclideanDivision(long a, long b) {
        assert (b != 0L) : "Precondition Failure";
        if (0L <= a) {
            if (0L <= b) {
                return a / b;
            }
            if (b == Long.MIN_VALUE) {
                return Long.divideUnsigned(a, Long.MIN_VALUE) * -1L;
            }
            return -(a / -b);
        }
        if (0L <= b) {
            return -(-(a + 1L) / b) - 1L;
        }
        if (b == Long.MIN_VALUE) {
            return Long.divideUnsigned(-(a + 1L), Long.MIN_VALUE) + 1L;
        }
        return -(a + 1L) / -b + 1L;
    }

    public static BigInteger EuclideanDivision(BigInteger a, BigInteger b) {
        assert (b.compareTo(BigInteger.ZERO) != 0) : "Precondition Failure";
        if (0 <= a.signum()) {
            if (0 <= b.signum()) {
                return a.divide(b);
            }
            return a.divide(b.negate()).negate();
        }
        if (0 <= b.signum()) {
            return a.add(BigInteger.ONE).negate().divide(b).negate().subtract(BigInteger.ONE);
        }
        return a.add(BigInteger.ONE).negate().divide(b.negate()).add(BigInteger.ONE);
    }

    public static byte EuclideanModulus(byte a, byte b) {
        assert (b != 0) : "Precondition Failure";
        return (byte)DafnyEuclidean.EuclideanModulus((int)a, (int)b);
    }

    public static short EuclideanModulus(short a, short b) {
        assert (b != 0) : "Precondition Failure";
        return (short)DafnyEuclidean.EuclideanModulus((int)a, (int)b);
    }

    public static int EuclideanModulus(int a, int b) {
        assert (b != 0) : "Precondition Failure";
        if (0 <= a) {
            if (b == Integer.MIN_VALUE) {
                return Integer.remainderUnsigned(a, b);
            }
            if (b < 0) {
                return a % -b;
            }
            return a % b;
        }
        if (a == Integer.MIN_VALUE || b == Integer.MIN_VALUE) {
            if (a == b) {
                return 0;
            }
            if (b == Integer.MIN_VALUE) {
                return b - Integer.remainderUnsigned(-a, b);
            }
            int bp = b < 0 ? -b : b;
            return bp - Integer.remainderUnsigned(a, bp);
        }
        int bp = b < 0 ? -b : b;
        int c = -a % bp;
        return c == 0 ? c : bp - c;
    }

    public static long EuclideanModulus(long a, long b) {
        assert (b != 0L) : "Precondition Failure";
        if (0L <= a) {
            if (b == Long.MIN_VALUE) {
                return Long.remainderUnsigned(a, b);
            }
            if (b < 0L) {
                return a % -b;
            }
            return a % b;
        }
        if (a == Long.MIN_VALUE || b == Long.MIN_VALUE) {
            if (a == b) {
                return 0L;
            }
            if (b == Long.MIN_VALUE) {
                return b - Long.remainderUnsigned(-a, b);
            }
            long bp = b < 0L ? -b : b;
            return bp - Long.remainderUnsigned(a, bp);
        }
        long bp = b < 0L ? -b : b;
        long c = -a % bp;
        return c == 0L ? c : bp - c;
    }

    public static BigInteger EuclideanModulus(BigInteger a, BigInteger b) {
        assert (b.compareTo(BigInteger.ZERO) != 0) : "Precondition Failure";
        BigInteger bp = b.abs();
        if (0 <= a.signum()) {
            return a.mod(bp);
        }
        BigInteger c = a.negate().mod(bp);
        return c.equals(BigInteger.ZERO) ? c : bp.subtract(c);
    }
}

