# Validation Layers Source Documentation

This directory contains more detailed information about how each part of the Validation Layers work.

- [VK_LAYER_KHRONOS_validation overview](./khronos_validation_layer.md)
    - [Core Validation Checks](./core_checks.md)
    - [Error Message Overview](./error_messages.md)
    - [Best Practices Validation](./best_practices.md)
    - [Error Object (information used to print better error messages)](./error_object.md)
    - [Shader Debug Printf](./debug_printf.md)
    - [Legacy Detection](./legacy_detection.md)
    - [Fine Grained Locking](./fine_grained_locking.md)
        - [Fine Grained Locking - Usage](./fine_grained_locking_usage.md)
    - [Generated Code](./generated_code.md)
    - [GPU-Assisted Validation](./gpu_validation.md)
    - [Handle Wrapping](./handle_wrapping.md)
    - [Object Lifetimes](./object_lifetimes.md)
    - [VK_KHR_portability_subset](./portability_validation.md)
    - [Shader Validation](./shader_validation.md)
        - [Shader Sanitizer](./shader_sanitizer.md)
    - [Stateless Parameter Validation](./stateless_validation.md)
    - [Synchronization Validation Design](./syncval_design.md)
        - [Synchronization Validation Usage](./syncval_usage.md)
        - [Synchronization Validation Development](./syncval_development.md)
    - [Thread Safety Validation](./thread_safety.md)
    - [Limitations](./limitations.md)
- [Creating Tests](./creating_tests.md)