/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCompositionEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMWindow.h"
#include "JSDictionary.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCompositionEventPrototypeFunctionInitCompositionEvent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCompositionEventData(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCompositionEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCompositionEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCompositionEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCompositionEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCompositionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSCompositionEventPrototype>(vm.heap)) JSCompositionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCompositionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSCompositionEvent> JSCompositionEventConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSCompositionEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSCompositionEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    CompositionEventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillCompositionEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<CompositionEvent> event = CompositionEvent::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillCompositionEventInit(CompositionEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillUIEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("data", eventInit.data))
        return false;
    return true;
}

template<> JSValue JSCompositionEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSCompositionEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCompositionEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CompositionEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
}

template<> ConstructType JSCompositionEventConstructor::getConstructData(JSCell* cell, ConstructData& constructData)
{
#if ENABLE(DOM4_EVENTS_CONSTRUCTOR)
    UNUSED_PARAM(cell);
    constructData.native.function = construct;
    return ConstructTypeHost;
#else
    return Base::getConstructData(cell, constructData);
#endif
}

template<> const ClassInfo JSCompositionEventConstructor::s_info = { "CompositionEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCompositionEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCompositionEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCompositionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCompositionEventConstructor) } },
    { "data", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCompositionEventData), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initCompositionEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCompositionEventPrototypeFunctionInitCompositionEvent), (intptr_t) (0) } },
};

const ClassInfo JSCompositionEventPrototype::s_info = { "CompositionEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCompositionEventPrototype) };

void JSCompositionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCompositionEventPrototypeTableValues, *this);
}

const ClassInfo JSCompositionEvent::s_info = { "CompositionEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCompositionEvent) };

JSCompositionEvent::JSCompositionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CompositionEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCompositionEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCompositionEventPrototype::create(vm, globalObject, JSCompositionEventPrototype::createStructure(vm, globalObject, JSUIEvent::getPrototype(vm, globalObject)));
}

JSObject* JSCompositionEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCompositionEvent>(vm, globalObject);
}

EncodedJSValue jsCompositionEventData(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCompositionEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CompositionEvent", "data");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.data());
    return JSValue::encode(result);
}


EncodedJSValue jsCompositionEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCompositionEventPrototype* domObject = jsDynamicCast<JSCompositionEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCompositionEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCompositionEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCompositionEventPrototype* domObject = jsDynamicCast<JSCompositionEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSCompositionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCompositionEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCompositionEventPrototypeFunctionInitCompositionEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCompositionEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CompositionEvent", "initCompositionEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCompositionEvent::info());
    auto& impl = castedThis->wrapped();
    String typeArg = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool canBubbleArg = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool cancelableArg = state->argument(2).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    DOMWindow* viewArg = JSDOMWindow::toWrapped(state->argument(3));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String dataArg = state->argument(4).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.initCompositionEvent(typeArg, canBubbleArg, cancelableArg, viewArg, dataArg);
    return JSValue::encode(jsUndefined());
}


}
