/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSConvolverNode.h"

#include "AudioBuffer.h"
#include "ExceptionCode.h"
#include "JSAudioBuffer.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsConvolverNodeBuffer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSConvolverNodeBuffer(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsConvolverNodeNormalize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSConvolverNodeNormalize(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsConvolverNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSConvolverNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSConvolverNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSConvolverNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSConvolverNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSConvolverNodePrototype>(vm.heap)) JSConvolverNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSConvolverNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSConvolverNode> JSConvolverNodeConstructor;

template<> JSValue JSConvolverNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSConvolverNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSConvolverNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ConvolverNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSConvolverNodeConstructor::s_info = { "ConvolverNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSConvolverNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSConvolverNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsConvolverNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSConvolverNodeConstructor) } },
    { "buffer", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsConvolverNodeBuffer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSConvolverNodeBuffer) } },
    { "normalize", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsConvolverNodeNormalize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSConvolverNodeNormalize) } },
};

const ClassInfo JSConvolverNodePrototype::s_info = { "ConvolverNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSConvolverNodePrototype) };

void JSConvolverNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSConvolverNodePrototypeTableValues, *this);
}

const ClassInfo JSConvolverNode::s_info = { "ConvolverNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSConvolverNode) };

JSConvolverNode::JSConvolverNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ConvolverNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSConvolverNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSConvolverNodePrototype::create(vm, globalObject, JSConvolverNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSConvolverNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSConvolverNode>(vm, globalObject);
}

EncodedJSValue jsConvolverNodeBuffer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSConvolverNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ConvolverNode", "buffer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.buffer()));
    return JSValue::encode(result);
}


EncodedJSValue jsConvolverNodeNormalize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSConvolverNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ConvolverNode", "normalize");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.normalize());
    return JSValue::encode(result);
}


EncodedJSValue jsConvolverNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSConvolverNodePrototype* domObject = jsDynamicCast<JSConvolverNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSConvolverNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSConvolverNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSConvolverNodePrototype* domObject = jsDynamicCast<JSConvolverNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSConvolverNodeBuffer(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSConvolverNode* castedThis = jsDynamicCast<JSConvolverNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "ConvolverNode", "buffer");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    AudioBuffer* nativeValue = JSAudioBuffer::toWrapped(value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBuffer(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSConvolverNodeNormalize(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSConvolverNode* castedThis = jsDynamicCast<JSConvolverNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "ConvolverNode", "normalize");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setNormalize(nativeValue);
}


JSValue JSConvolverNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSConvolverNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSConvolverNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSConvolverNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ConvolverNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13ConvolverNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, ConvolverNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSConvolverNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, ConvolverNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSConvolverNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7ConvolverNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13ConvolverNodeE[2];
#if COMPILER(CLANG)
    // If this fails ConvolverNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(ConvolverNode), ConvolverNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // ConvolverNode has subclasses. If ConvolverNode has subclasses that get passed
    // to toJS() we currently require ConvolverNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSConvolverNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
