/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCrypto.h"

#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

#if ENABLE(SUBTLE_CRYPTO)
#include "JSSubtleCrypto.h"
#include "SubtleCrypto.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCryptoPrototypeFunctionGetRandomValues(JSC::ExecState*);

// Attributes

#if ENABLE(SUBTLE_CRYPTO)
JSC::EncodedJSValue jsCryptoWebkitSubtle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
void setJSCryptoConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCryptoPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCryptoPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCryptoPrototype* ptr = new (NotNull, JSC::allocateCell<JSCryptoPrototype>(vm.heap)) JSCryptoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCryptoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSCryptoPrototypeTableValues[] =
{
#if ENABLE(SUBTLE_CRYPTO)
    { "webkitSubtle", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCryptoWebkitSubtle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "getRandomValues", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCryptoPrototypeFunctionGetRandomValues), (intptr_t) (1) } },
};

const ClassInfo JSCryptoPrototype::s_info = { "CryptoPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCryptoPrototype) };

void JSCryptoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCryptoPrototypeTableValues, *this);
}

const ClassInfo JSCrypto::s_info = { "Crypto", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCrypto) };

JSCrypto::JSCrypto(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Crypto>&& impl)
    : JSDOMWrapper<Crypto>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCrypto::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCryptoPrototype::create(vm, globalObject, JSCryptoPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCrypto::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCrypto>(vm, globalObject);
}

void JSCrypto::destroy(JSC::JSCell* cell)
{
    JSCrypto* thisObject = static_cast<JSCrypto*>(cell);
    thisObject->JSCrypto::~JSCrypto();
}

#if ENABLE(SUBTLE_CRYPTO)
EncodedJSValue jsCryptoWebkitSubtle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCrypto*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Crypto", "webkitSubtle");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.subtle()));
    return JSValue::encode(result);
}

#endif

void setJSCryptoConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCryptoPrototype* domObject = jsDynamicCast<JSCryptoPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

EncodedJSValue JSC_HOST_CALL jsCryptoPrototypeFunctionGetRandomValues(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCrypto*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Crypto", "getRandomValues");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCrypto::info());
    return JSValue::encode(castedThis->getRandomValues(*state));
}

bool JSCryptoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsCrypto = jsCast<JSCrypto*>(handle.slot()->asCell());
    Document* root = WTF::getPtr(jsCrypto->wrapped().document());
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSCryptoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCrypto = jsCast<JSCrypto*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCrypto->wrapped(), jsCrypto);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Crypto@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6CryptoE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Crypto* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSCrypto>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Crypto* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCrypto>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Crypto@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore6CryptoE[2];
#if COMPILER(CLANG)
    // If this fails Crypto does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Crypto), Crypto_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Crypto has subclasses. If Crypto has subclasses that get passed
    // to toJS() we currently require Crypto you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSCrypto>(globalObject, impl);
}

Crypto* JSCrypto::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCrypto*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
