/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMFormData.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMFormDataPrototypeFunctionAppend(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDOMFormDataConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMFormDataConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMFormDataPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMFormDataPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMFormDataPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMFormDataPrototype>(vm.heap)) JSDOMFormDataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMFormDataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSDOMFormData> JSDOMFormDataConstructor;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSDOMFormDataConstructor::construct(JSC::ExecState* state)
{
    return constructJSDOMFormData(state);
}

template<> JSValue JSDOMFormDataConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMFormDataConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMFormData::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("FormData"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDOMFormDataConstructor::s_info = { "FormData", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMFormDataConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMFormDataPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFormDataConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMFormDataConstructor) } },
    { "append", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMFormDataPrototypeFunctionAppend), (intptr_t) (0) } },
};

const ClassInfo JSDOMFormDataPrototype::s_info = { "FormDataPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMFormDataPrototype) };

void JSDOMFormDataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMFormDataPrototypeTableValues, *this);
}

const ClassInfo JSDOMFormData::s_info = { "FormData", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMFormData) };

JSDOMFormData::JSDOMFormData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMFormData>&& impl)
    : JSDOMWrapper<DOMFormData>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDOMFormData::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDOMFormDataPrototype::create(vm, globalObject, JSDOMFormDataPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDOMFormData::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMFormData>(vm, globalObject);
}

void JSDOMFormData::destroy(JSC::JSCell* cell)
{
    JSDOMFormData* thisObject = static_cast<JSDOMFormData*>(cell);
    thisObject->JSDOMFormData::~JSDOMFormData();
}

EncodedJSValue jsDOMFormDataConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDOMFormDataPrototype* domObject = jsDynamicCast<JSDOMFormDataPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDOMFormData::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDOMFormDataConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDOMFormDataPrototype* domObject = jsDynamicCast<JSDOMFormDataPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSDOMFormData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMFormDataConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMFormDataPrototypeFunctionAppend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMFormData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMFormData", "append");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMFormData::info());
    return JSValue::encode(castedThis->append(*state));
}

bool JSDOMFormDataOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMFormDataOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMFormData = jsCast<JSDOMFormData*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMFormData->wrapped(), jsDOMFormData);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMFormData* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDOMFormData>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMFormData* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMFormData>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMFormData.
    COMPILE_ASSERT(!__is_polymorphic(DOMFormData), DOMFormData_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSDOMFormData>(globalObject, impl);
}

DOMFormData* JSDOMFormData::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMFormData*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
