/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocumentFragment.h"

#include "Document.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSElement.h"
#include "JSHTMLCollection.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionGetElementById(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionPrepend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionAppend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionQuerySelector(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionQuerySelectorAll(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDocumentFragmentChildren(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentFragmentFirstElementChild(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentFragmentLastElementChild(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentFragmentChildElementCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentFragmentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentFragmentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDocumentFragmentPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDocumentFragmentPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDocumentFragmentPrototype* ptr = new (NotNull, JSC::allocateCell<JSDocumentFragmentPrototype>(vm.heap)) JSDocumentFragmentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDocumentFragmentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSDocumentFragment> JSDocumentFragmentConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSDocumentFragmentConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSDocumentFragmentConstructor*>(state->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "DocumentFragment");
    auto& document = downcast<Document>(*context);
    RefPtr<DocumentFragment> object = DocumentFragment::create(document);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSDocumentFragmentConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSDocumentFragmentConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDocumentFragment::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("DocumentFragment"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDocumentFragmentConstructor::s_info = { "DocumentFragment", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDocumentFragmentConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDocumentFragmentPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFragmentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentFragmentConstructor) } },
    { "children", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFragmentChildren), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "firstElementChild", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFragmentFirstElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lastElementChild", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFragmentLastElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "childElementCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFragmentChildElementCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getElementById", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentFragmentPrototypeFunctionGetElementById), (intptr_t) (0) } },
    { "prepend", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentFragmentPrototypeFunctionPrepend), (intptr_t) (0) } },
    { "append", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentFragmentPrototypeFunctionAppend), (intptr_t) (0) } },
    { "querySelector", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentFragmentPrototypeFunctionQuerySelector), (intptr_t) (1) } },
    { "querySelectorAll", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentFragmentPrototypeFunctionQuerySelectorAll), (intptr_t) (1) } },
};

const ClassInfo JSDocumentFragmentPrototype::s_info = { "DocumentFragmentPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDocumentFragmentPrototype) };

void JSDocumentFragmentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDocumentFragmentPrototypeTableValues, *this);
}

const ClassInfo JSDocumentFragment::s_info = { "DocumentFragment", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDocumentFragment) };

JSDocumentFragment::JSDocumentFragment(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DocumentFragment>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDocumentFragment::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDocumentFragmentPrototype::create(vm, globalObject, JSDocumentFragmentPrototype::createStructure(vm, globalObject, JSNode::getPrototype(vm, globalObject)));
}

JSObject* JSDocumentFragment::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocumentFragment>(vm, globalObject);
}

EncodedJSValue jsDocumentFragmentChildren(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDocumentFragment*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DocumentFragment", "children");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.children()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentFragmentFirstElementChild(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDocumentFragment*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DocumentFragment", "firstElementChild");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.firstElementChild()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentFragmentLastElementChild(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDocumentFragment*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DocumentFragment", "lastElementChild");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.lastElementChild()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentFragmentChildElementCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDocumentFragment*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DocumentFragment", "childElementCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.childElementCount());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentFragmentConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDocumentFragmentPrototype* domObject = jsDynamicCast<JSDocumentFragmentPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDocumentFragment::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDocumentFragmentConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDocumentFragmentPrototype* domObject = jsDynamicCast<JSDocumentFragmentPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSDocumentFragment::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentFragmentConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionGetElementById(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentFragment*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentFragment", "getElementById");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentFragment::info());
    auto& impl = castedThis->wrapped();
    AtomicString elementId = state->argument(0).toString(state)->toExistingAtomicString(state).get();
    if (elementId.isNull())
        return JSValue::encode(jsNull());
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementById(elementId)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionPrepend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentFragment*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentFragment", "prepend");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentFragment::info());
    return JSValue::encode(castedThis->prepend(*state));
}

EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionAppend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentFragment*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentFragment", "append");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentFragment::info());
    return JSValue::encode(castedThis->append(*state));
}

EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionQuerySelector(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentFragment*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentFragment", "querySelector");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentFragment::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.querySelector(selectors, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionQuerySelectorAll(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDocumentFragment*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DocumentFragment", "querySelectorAll");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocumentFragment::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.querySelectorAll(selectors, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSDocumentFragment::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDocumentFragment*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
