/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTBlendMinMax.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

class JSEXTBlendMinMaxPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSEXTBlendMinMaxPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTBlendMinMaxPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTBlendMinMaxPrototype>(vm.heap)) JSEXTBlendMinMaxPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTBlendMinMaxPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSEXTBlendMinMaxPrototypeTableValues[] =
{
    { "MIN_EXT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8007) } },
    { "MAX_EXT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8008) } },
};

const ClassInfo JSEXTBlendMinMaxPrototype::s_info = { "EXTBlendMinMaxPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEXTBlendMinMaxPrototype) };

void JSEXTBlendMinMaxPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTBlendMinMaxPrototypeTableValues, *this);
}

const ClassInfo JSEXTBlendMinMax::s_info = { "EXTBlendMinMax", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEXTBlendMinMax) };

JSEXTBlendMinMax::JSEXTBlendMinMax(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTBlendMinMax>&& impl)
    : JSDOMWrapper<EXTBlendMinMax>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSEXTBlendMinMax::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSEXTBlendMinMaxPrototype::create(vm, globalObject, JSEXTBlendMinMaxPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSEXTBlendMinMax::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEXTBlendMinMax>(vm, globalObject);
}

void JSEXTBlendMinMax::destroy(JSC::JSCell* cell)
{
    JSEXTBlendMinMax* thisObject = static_cast<JSEXTBlendMinMax*>(cell);
    thisObject->JSEXTBlendMinMax::~JSEXTBlendMinMax();
}

bool JSEXTBlendMinMaxOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsEXTBlendMinMax = jsCast<JSEXTBlendMinMax*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsEXTBlendMinMax->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSEXTBlendMinMaxOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTBlendMinMax = jsCast<JSEXTBlendMinMax*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTBlendMinMax->wrapped(), jsEXTBlendMinMax);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTBlendMinMax@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14EXTBlendMinMaxE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, EXTBlendMinMax* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSEXTBlendMinMax>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, EXTBlendMinMax* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSEXTBlendMinMax>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7EXTBlendMinMax@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14EXTBlendMinMaxE[2];
#if COMPILER(CLANG)
    // If this fails EXTBlendMinMax does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(EXTBlendMinMax), EXTBlendMinMax_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // EXTBlendMinMax has subclasses. If EXTBlendMinMax has subclasses that get passed
    // to toJS() we currently require EXTBlendMinMax you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSEXTBlendMinMax>(globalObject, impl);
}

EXTBlendMinMax* JSEXTBlendMinMax::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTBlendMinMax*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
