/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLMarqueeElement.h"

#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStart(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStop(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsHTMLMarqueeElementBehavior(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementBehavior(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementBgColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementBgColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementDirection(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementDirection(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementHspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementHspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementLoop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementLoop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementScrollAmount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementScrollAmount(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementScrollDelay(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementScrollDelay(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementTrueSpeed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementTrueSpeed(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementVspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementVspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLMarqueeElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLMarqueeElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMarqueeElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMarqueeElementPrototype>(vm.heap)) JSHTMLMarqueeElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMarqueeElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLMarqueeElement> JSHTMLMarqueeElementConstructor;

template<> JSValue JSHTMLMarqueeElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMarqueeElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMarqueeElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLMarqueeElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLMarqueeElementConstructor::s_info = { "HTMLMarqueeElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMarqueeElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLMarqueeElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementConstructor) } },
    { "behavior", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementBehavior), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementBehavior) } },
    { "bgColor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementBgColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementBgColor) } },
    { "direction", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementDirection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementDirection) } },
    { "height", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementHeight) } },
    { "hspace", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementHspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementHspace) } },
    { "loop", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementLoop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementLoop) } },
    { "scrollAmount", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementScrollAmount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementScrollAmount) } },
    { "scrollDelay", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementScrollDelay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementScrollDelay) } },
    { "trueSpeed", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementTrueSpeed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementTrueSpeed) } },
    { "vspace", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementVspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementVspace) } },
    { "width", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementWidth) } },
    { "start", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMarqueeElementPrototypeFunctionStart), (intptr_t) (0) } },
    { "stop", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMarqueeElementPrototypeFunctionStop), (intptr_t) (0) } },
};

const ClassInfo JSHTMLMarqueeElementPrototype::s_info = { "HTMLMarqueeElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMarqueeElementPrototype) };

void JSHTMLMarqueeElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMarqueeElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLMarqueeElement::s_info = { "HTMLMarqueeElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMarqueeElement) };

JSHTMLMarqueeElement::JSHTMLMarqueeElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMarqueeElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLMarqueeElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLMarqueeElementPrototype::create(vm, globalObject, JSHTMLMarqueeElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLMarqueeElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMarqueeElement>(vm, globalObject);
}

EncodedJSValue jsHTMLMarqueeElementBehavior(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "behavior");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::behaviorAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementBgColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "bgColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementDirection(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "direction");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::directionAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "height");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementHspace(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "hspace");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::hspaceAttr)));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementLoop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "loop");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.loop());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementScrollAmount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "scrollAmount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.scrollAmount());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementScrollDelay(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "scrollDelay");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.scrollDelay());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementTrueSpeed(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "trueSpeed");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::truespeedAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementVspace(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "vspace");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::vspaceAttr)));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMarqueeElement", "width");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMarqueeElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLMarqueeElementPrototype* domObject = jsDynamicCast<JSHTMLMarqueeElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLMarqueeElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLMarqueeElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLMarqueeElementPrototype* domObject = jsDynamicCast<JSHTMLMarqueeElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLMarqueeElementBehavior(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "behavior");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::behaviorAttr, nativeValue);
}


void setJSHTMLMarqueeElementBgColor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "bgColor");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::bgcolorAttr, nativeValue);
}


void setJSHTMLMarqueeElementDirection(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "direction");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::directionAttr, nativeValue);
}


void setJSHTMLMarqueeElementHeight(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "height");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::heightAttr, nativeValue);
}


void setJSHTMLMarqueeElementHspace(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "hspace");
        return;
    }
    auto& impl = castedThis->wrapped();
    unsigned nativeValue = toUInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr, nativeValue);
}


void setJSHTMLMarqueeElementLoop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "loop");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLoop(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMarqueeElementScrollAmount(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "scrollAmount");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setScrollAmount(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMarqueeElementScrollDelay(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "scrollDelay");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setScrollDelay(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMarqueeElementTrueSpeed(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "trueSpeed");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::truespeedAttr, nativeValue);
}


void setJSHTMLMarqueeElementVspace(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "vspace");
        return;
    }
    auto& impl = castedThis->wrapped();
    unsigned nativeValue = toUInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr, nativeValue);
}


void setJSHTMLMarqueeElementWidth(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMarqueeElement* castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMarqueeElement", "width");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::widthAttr, nativeValue);
}


JSValue JSHTMLMarqueeElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMarqueeElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStart(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMarqueeElement", "start");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMarqueeElement::info());
    auto& impl = castedThis->wrapped();
    impl.start();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStop(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMarqueeElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMarqueeElement", "stop");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMarqueeElement::info());
    auto& impl = castedThis->wrapped();
    impl.stop();
    return JSValue::encode(jsUndefined());
}

void JSHTMLMarqueeElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLMarqueeElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
