/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBOpenDBRequest.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsIDBOpenDBRequestOnblocked(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSIDBOpenDBRequestOnblocked(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBOpenDBRequestOnupgradeneeded(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSIDBOpenDBRequestOnupgradeneeded(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBOpenDBRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSIDBOpenDBRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSIDBOpenDBRequestPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSIDBOpenDBRequestPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBOpenDBRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBOpenDBRequestPrototype>(vm.heap)) JSIDBOpenDBRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBOpenDBRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSIDBOpenDBRequest> JSIDBOpenDBRequestConstructor;

template<> JSValue JSIDBOpenDBRequestConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSIDBRequest::getConstructor(vm, &globalObject);
}

template<> void JSIDBOpenDBRequestConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBOpenDBRequest::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("IDBOpenDBRequest"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSIDBOpenDBRequestConstructor::s_info = { "IDBOpenDBRequest", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBOpenDBRequestConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBOpenDBRequestPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBOpenDBRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBOpenDBRequestConstructor) } },
    { "onblocked", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBOpenDBRequestOnblocked), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBOpenDBRequestOnblocked) } },
    { "onupgradeneeded", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBOpenDBRequestOnupgradeneeded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBOpenDBRequestOnupgradeneeded) } },
};

const ClassInfo JSIDBOpenDBRequestPrototype::s_info = { "IDBOpenDBRequestPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBOpenDBRequestPrototype) };

void JSIDBOpenDBRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBOpenDBRequestPrototypeTableValues, *this);
}

const ClassInfo JSIDBOpenDBRequest::s_info = { "IDBOpenDBRequest", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBOpenDBRequest) };

JSIDBOpenDBRequest::JSIDBOpenDBRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBOpenDBRequest>&& impl)
    : JSIDBRequest(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSIDBOpenDBRequest::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSIDBOpenDBRequestPrototype::create(vm, globalObject, JSIDBOpenDBRequestPrototype::createStructure(vm, globalObject, JSIDBRequest::getPrototype(vm, globalObject)));
}

JSObject* JSIDBOpenDBRequest::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBOpenDBRequest>(vm, globalObject);
}

EncodedJSValue jsIDBOpenDBRequestOnblocked(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBOpenDBRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBOpenDBRequest", "onblocked");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().blockedEvent));
}


EncodedJSValue jsIDBOpenDBRequestOnupgradeneeded(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBOpenDBRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBOpenDBRequest", "onupgradeneeded");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().upgradeneededEvent));
}


EncodedJSValue jsIDBOpenDBRequestConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSIDBOpenDBRequestPrototype* domObject = jsDynamicCast<JSIDBOpenDBRequestPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSIDBOpenDBRequest::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSIDBOpenDBRequestConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSIDBOpenDBRequestPrototype* domObject = jsDynamicCast<JSIDBOpenDBRequestPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSIDBOpenDBRequestOnblocked(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSIDBOpenDBRequest* castedThis = jsDynamicCast<JSIDBOpenDBRequest*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "IDBOpenDBRequest", "onblocked");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().blockedEvent, value);
}


void setJSIDBOpenDBRequestOnupgradeneeded(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSIDBOpenDBRequest* castedThis = jsDynamicCast<JSIDBOpenDBRequest*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "IDBOpenDBRequest", "onupgradeneeded");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().upgradeneededEvent, value);
}


JSValue JSIDBOpenDBRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBOpenDBRequestConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBOpenDBRequest::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBOpenDBRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSIDBOpenDBRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsIDBOpenDBRequest = jsCast<JSIDBOpenDBRequest*>(handle.slot()->asCell());
    if (jsIDBOpenDBRequest->wrapped().hasPendingActivity())
        return true;
    if (jsIDBOpenDBRequest->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBOpenDBRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBOpenDBRequest = jsCast<JSIDBOpenDBRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBOpenDBRequest->wrapped(), jsIDBOpenDBRequest);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBOpenDBRequest* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSIDBOpenDBRequest>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBOpenDBRequest* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBOpenDBRequest>(globalObject, impl))
        return result;
    return createNewWrapper<JSIDBOpenDBRequest>(globalObject, impl);
}

IDBOpenDBRequest* JSIDBOpenDBRequest::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBOpenDBRequest*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
