/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)

#include "JSMediaElementAudioSourceNode.h"

#include "HTMLMediaElement.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSHTMLMediaElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsMediaElementAudioSourceNodeMediaElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaElementAudioSourceNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaElementAudioSourceNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaElementAudioSourceNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMediaElementAudioSourceNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaElementAudioSourceNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaElementAudioSourceNodePrototype>(vm.heap)) JSMediaElementAudioSourceNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaElementAudioSourceNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSMediaElementAudioSourceNode> JSMediaElementAudioSourceNodeConstructor;

template<> JSValue JSMediaElementAudioSourceNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSMediaElementAudioSourceNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaElementAudioSourceNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MediaElementAudioSourceNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSMediaElementAudioSourceNodeConstructor::s_info = { "MediaElementAudioSourceNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaElementAudioSourceNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaElementAudioSourceNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaElementAudioSourceNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaElementAudioSourceNodeConstructor) } },
    { "mediaElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaElementAudioSourceNodeMediaElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMediaElementAudioSourceNodePrototype::s_info = { "MediaElementAudioSourceNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaElementAudioSourceNodePrototype) };

void JSMediaElementAudioSourceNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaElementAudioSourceNodePrototypeTableValues, *this);
}

const ClassInfo JSMediaElementAudioSourceNode::s_info = { "MediaElementAudioSourceNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaElementAudioSourceNode) };

JSMediaElementAudioSourceNode::JSMediaElementAudioSourceNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaElementAudioSourceNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMediaElementAudioSourceNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMediaElementAudioSourceNodePrototype::create(vm, globalObject, JSMediaElementAudioSourceNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSMediaElementAudioSourceNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaElementAudioSourceNode>(vm, globalObject);
}

EncodedJSValue jsMediaElementAudioSourceNodeMediaElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaElementAudioSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaElementAudioSourceNode", "mediaElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.mediaElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaElementAudioSourceNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMediaElementAudioSourceNodePrototype* domObject = jsDynamicCast<JSMediaElementAudioSourceNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMediaElementAudioSourceNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMediaElementAudioSourceNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMediaElementAudioSourceNodePrototype* domObject = jsDynamicCast<JSMediaElementAudioSourceNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSMediaElementAudioSourceNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaElementAudioSourceNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaElementAudioSourceNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMediaElementAudioSourceNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaElementAudioSourceNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27MediaElementAudioSourceNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaElementAudioSourceNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMediaElementAudioSourceNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaElementAudioSourceNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaElementAudioSourceNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MediaElementAudioSourceNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore27MediaElementAudioSourceNodeE[2];
#if COMPILER(CLANG)
    // If this fails MediaElementAudioSourceNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MediaElementAudioSourceNode), MediaElementAudioSourceNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MediaElementAudioSourceNode has subclasses. If MediaElementAudioSourceNode has subclasses that get passed
    // to toJS() we currently require MediaElementAudioSourceNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSMediaElementAudioSourceNode>(globalObject, impl);
}


}

#endif // ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
