/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNode.h"

#include "Document.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDocument.h"
#include "JSElement.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeList.h"
#include "URL.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionInsertBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionReplaceChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionRemoveChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionAppendChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionHasChildNodes(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionCloneNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionNormalize(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsSameNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsEqualNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionLookupPrefix(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsDefaultNamespace(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionLookupNamespaceURI(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionCompareDocumentPosition(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionContains(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsNodeNodeName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeNodeValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNodeNodeValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNodeNodeType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeParentNode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeChildNodes(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeFirstChild(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeLastChild(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodePreviousSibling(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeNextSibling(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeOwnerDocument(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(SHADOW_DOM)
JSC::EncodedJSValue jsNodeTreeRoot(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsNodeNamespaceURI(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodePrefix(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNodePrefix(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNodeLocalName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeBaseURI(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeTextContent(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNodeTextContent(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNodeParentElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSNodePrototype>(vm.heap)) JSNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSNode> JSNodeConstructor;

/* Hash table for constructor */

static const HashTableValue JSNodeConstructorTableValues[] =
{
    { "ELEMENT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "ATTRIBUTE_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TEXT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CDATA_SECTION_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "ENTITY_REFERENCE_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "ENTITY_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "PROCESSING_INSTRUCTION_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "COMMENT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "DOCUMENT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "DOCUMENT_TYPE_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "DOCUMENT_FRAGMENT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "NOTATION_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "DOCUMENT_POSITION_DISCONNECTED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOCUMENT_POSITION_PRECEDING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
    { "DOCUMENT_POSITION_FOLLOWING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x04) } },
    { "DOCUMENT_POSITION_CONTAINS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x08) } },
    { "DOCUMENT_POSITION_CONTAINED_BY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x10) } },
    { "DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x20) } },
};


COMPILE_ASSERT(1 == Node::ELEMENT_NODE, NodeEnumELEMENT_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Node::ATTRIBUTE_NODE, NodeEnumATTRIBUTE_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == Node::TEXT_NODE, NodeEnumTEXT_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == Node::CDATA_SECTION_NODE, NodeEnumCDATA_SECTION_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == Node::ENTITY_REFERENCE_NODE, NodeEnumENTITY_REFERENCE_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == Node::ENTITY_NODE, NodeEnumENTITY_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == Node::PROCESSING_INSTRUCTION_NODE, NodeEnumPROCESSING_INSTRUCTION_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == Node::COMMENT_NODE, NodeEnumCOMMENT_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(9 == Node::DOCUMENT_NODE, NodeEnumDOCUMENT_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(10 == Node::DOCUMENT_TYPE_NODE, NodeEnumDOCUMENT_TYPE_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(11 == Node::DOCUMENT_FRAGMENT_NODE, NodeEnumDOCUMENT_FRAGMENT_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(12 == Node::NOTATION_NODE, NodeEnumNOTATION_NODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x01 == Node::DOCUMENT_POSITION_DISCONNECTED, NodeEnumDOCUMENT_POSITION_DISCONNECTEDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x02 == Node::DOCUMENT_POSITION_PRECEDING, NodeEnumDOCUMENT_POSITION_PRECEDINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x04 == Node::DOCUMENT_POSITION_FOLLOWING, NodeEnumDOCUMENT_POSITION_FOLLOWINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x08 == Node::DOCUMENT_POSITION_CONTAINS, NodeEnumDOCUMENT_POSITION_CONTAINSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x10 == Node::DOCUMENT_POSITION_CONTAINED_BY, NodeEnumDOCUMENT_POSITION_CONTAINED_BYIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x20 == Node::DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC, NodeEnumDOCUMENT_POSITION_IMPLEMENTATION_SPECIFICIsWrongUseDoNotCheckConstants);

template<> JSValue JSNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Node"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSNodeConstructorTableValues, *this);
}

template<> const ClassInfo JSNodeConstructor::s_info = { "Node", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNodeConstructor) } },
    { "nodeName", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeNodeName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nodeValue", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeNodeValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNodeNodeValue) } },
    { "nodeType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeNodeType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "parentNode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeParentNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "childNodes", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeChildNodes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "firstChild", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFirstChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lastChild", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeLastChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "previousSibling", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodePreviousSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextSibling", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeNextSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ownerDocument", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeOwnerDocument), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(SHADOW_DOM)
    { "treeRoot", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeTreeRoot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "namespaceURI", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeNamespaceURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "prefix", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodePrefix), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNodePrefix) } },
    { "localName", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeLocalName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "baseURI", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeBaseURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "textContent", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeTextContent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNodeTextContent) } },
    { "parentElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeParentElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "insertBefore", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionInsertBefore), (intptr_t) (2) } },
    { "replaceChild", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionReplaceChild), (intptr_t) (2) } },
    { "removeChild", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionRemoveChild), (intptr_t) (1) } },
    { "appendChild", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionAppendChild), (intptr_t) (1) } },
    { "hasChildNodes", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionHasChildNodes), (intptr_t) (0) } },
    { "cloneNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionCloneNode), (intptr_t) (0) } },
    { "normalize", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionNormalize), (intptr_t) (0) } },
    { "isSameNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionIsSameNode), (intptr_t) (0) } },
    { "isEqualNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionIsEqualNode), (intptr_t) (0) } },
    { "lookupPrefix", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionLookupPrefix), (intptr_t) (0) } },
    { "isDefaultNamespace", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionIsDefaultNamespace), (intptr_t) (0) } },
    { "lookupNamespaceURI", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionLookupNamespaceURI), (intptr_t) (0) } },
    { "compareDocumentPosition", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionCompareDocumentPosition), (intptr_t) (0) } },
    { "contains", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodePrototypeFunctionContains), (intptr_t) (0) } },
    { "ELEMENT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "ATTRIBUTE_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TEXT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CDATA_SECTION_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "ENTITY_REFERENCE_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "ENTITY_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "PROCESSING_INSTRUCTION_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "COMMENT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "DOCUMENT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "DOCUMENT_TYPE_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "DOCUMENT_FRAGMENT_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "NOTATION_NODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "DOCUMENT_POSITION_DISCONNECTED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOCUMENT_POSITION_PRECEDING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
    { "DOCUMENT_POSITION_FOLLOWING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x04) } },
    { "DOCUMENT_POSITION_CONTAINS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x08) } },
    { "DOCUMENT_POSITION_CONTAINED_BY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x10) } },
    { "DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x20) } },
};

const ClassInfo JSNodePrototype::s_info = { "NodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNodePrototype) };

void JSNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNodePrototypeTableValues, *this);
}

const ClassInfo JSNode::s_info = { "Node", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNode) };

JSNode::JSNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Node>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSNodePrototype::create(vm, globalObject, JSNodePrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNode>(vm, globalObject);
}

EncodedJSValue jsNodeNodeName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "nodeName");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.nodeName());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeNodeValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "nodeValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.nodeValue());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeNodeType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "nodeType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.nodeType());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeParentNode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "parentNode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.parentNode()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeChildNodes(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "childNodes");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.childNodes()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeFirstChild(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "firstChild");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.firstChild()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeLastChild(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "lastChild");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.lastChild()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodePreviousSibling(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "previousSibling");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.previousSibling()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeNextSibling(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "nextSibling");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.nextSibling()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeOwnerDocument(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "ownerDocument");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.ownerDocument()));
    return JSValue::encode(result);
}


#if ENABLE(SHADOW_DOM)
EncodedJSValue jsNodeTreeRoot(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "treeRoot");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.highestAncestor()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsNodeNamespaceURI(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "namespaceURI");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.namespaceURI());
    return JSValue::encode(result);
}


EncodedJSValue jsNodePrefix(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "prefix");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.prefix());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeLocalName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "localName");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.localName());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeBaseURI(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "baseURI");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.baseURI());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeTextContent(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "textContent");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.textContent());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeParentElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsNodeCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Node", "parentElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.parentElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSNodePrototype* domObject = jsDynamicCast<JSNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSNodePrototype* domObject = jsDynamicCast<JSNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSNodeNodeValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNode* castedThis = jsNodeCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Node", "nodeValue");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setNodeValue(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSNodePrefix(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNode* castedThis = jsNodeCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Node", "prefix");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPrefix(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSNodeTextContent(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNode* castedThis = jsNodeCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Node", "textContent");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithUndefinedOrNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTextContent(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionInsertBefore(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "insertBefore");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    return JSValue::encode(castedThis->insertBefore(*state));
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionReplaceChild(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "replaceChild");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    return JSValue::encode(castedThis->replaceChild(*state));
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionRemoveChild(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "removeChild");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    return JSValue::encode(castedThis->removeChild(*state));
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionAppendChild(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "appendChild");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    return JSValue::encode(castedThis->appendChild(*state));
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionHasChildNodes(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "hasChildNodes");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.hasChildNodes());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionCloneNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "cloneNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    bool deep = state->argument(0).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.cloneNode(deep)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionNormalize(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "normalize");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    impl.normalize();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsSameNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "isSameNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    Node* other = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.isSameNode(other));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsEqualNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "isEqualNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    Node* other = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.isEqualNode(other));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionLookupPrefix(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "lookupPrefix");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    String namespaceURI = valueToStringWithNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.lookupPrefix(namespaceURI));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsDefaultNamespace(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "isDefaultNamespace");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    String namespaceURI = valueToStringWithNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.isDefaultNamespace(namespaceURI));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionLookupNamespaceURI(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "lookupNamespaceURI");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    String prefix = valueToStringWithNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.lookupNamespaceURI(prefix));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionCompareDocumentPosition(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "compareDocumentPosition");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    Node* other = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.compareDocumentPosition(other));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionContains(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsNodeCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Node", "contains");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNode::info());
    auto& impl = castedThis->wrapped();
    Node* other = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.contains(other));
    return JSValue::encode(result);
}

void JSNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNode = jsCast<JSNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNode->wrapped(), jsNode);
}

Node* JSNode::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsNodeCast(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
