/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOfflineAudioContext.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsOfflineAudioContextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSOfflineAudioContextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSOfflineAudioContextPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSOfflineAudioContextPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOfflineAudioContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSOfflineAudioContextPrototype>(vm.heap)) JSOfflineAudioContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOfflineAudioContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSOfflineAudioContext> JSOfflineAudioContextConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSOfflineAudioContextConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSOfflineAudioContextConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned numberOfChannels = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned numberOfFrames = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sampleRate = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "OfflineAudioContext");
    RefPtr<OfflineAudioContext> object = OfflineAudioContext::create(*context, numberOfChannels, numberOfFrames, sampleRate, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSOfflineAudioContextConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioContext::getConstructor(vm, &globalObject);
}

template<> void JSOfflineAudioContextConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSOfflineAudioContext::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("webkitOfflineAudioContext"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(3), ReadOnly | DontEnum);
}

template<> const ClassInfo JSOfflineAudioContextConstructor::s_info = { "webkitOfflineAudioContext", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOfflineAudioContextConstructor) };

/* Hash table for prototype */

static const HashTableValue JSOfflineAudioContextPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOfflineAudioContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOfflineAudioContextConstructor) } },
};

const ClassInfo JSOfflineAudioContextPrototype::s_info = { "webkitOfflineAudioContextPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOfflineAudioContextPrototype) };

void JSOfflineAudioContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOfflineAudioContextPrototypeTableValues, *this);
}

const ClassInfo JSOfflineAudioContext::s_info = { "webkitOfflineAudioContext", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOfflineAudioContext) };

JSOfflineAudioContext::JSOfflineAudioContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OfflineAudioContext>&& impl)
    : JSAudioContext(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSOfflineAudioContext::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSOfflineAudioContextPrototype::create(vm, globalObject, JSOfflineAudioContextPrototype::createStructure(vm, globalObject, JSAudioContext::getPrototype(vm, globalObject)));
}

JSObject* JSOfflineAudioContext::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOfflineAudioContext>(vm, globalObject);
}

EncodedJSValue jsOfflineAudioContextConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSOfflineAudioContextPrototype* domObject = jsDynamicCast<JSOfflineAudioContextPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSOfflineAudioContext::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSOfflineAudioContextConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSOfflineAudioContextPrototype* domObject = jsDynamicCast<JSOfflineAudioContextPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSOfflineAudioContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOfflineAudioContextConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSOfflineAudioContext::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSOfflineAudioContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSOfflineAudioContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsOfflineAudioContext = jsCast<JSOfflineAudioContext*>(handle.slot()->asCell());
    if (jsOfflineAudioContext->wrapped().hasPendingActivity())
        return true;
    if (jsOfflineAudioContext->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSOfflineAudioContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOfflineAudioContext = jsCast<JSOfflineAudioContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOfflineAudioContext->wrapped(), jsOfflineAudioContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OfflineAudioContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19OfflineAudioContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, OfflineAudioContext* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSOfflineAudioContext>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, OfflineAudioContext* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSOfflineAudioContext>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7OfflineAudioContext@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19OfflineAudioContextE[2];
#if COMPILER(CLANG)
    // If this fails OfflineAudioContext does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(OfflineAudioContext), OfflineAudioContext_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // OfflineAudioContext has subclasses. If OfflineAudioContext has subclasses that get passed
    // to toJS() we currently require OfflineAudioContext you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSOfflineAudioContext>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
