/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPeriodicWave.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsPeriodicWaveConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPeriodicWaveConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPeriodicWavePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSPeriodicWavePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPeriodicWavePrototype* ptr = new (NotNull, JSC::allocateCell<JSPeriodicWavePrototype>(vm.heap)) JSPeriodicWavePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPeriodicWavePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSPeriodicWave> JSPeriodicWaveConstructor;

template<> JSValue JSPeriodicWaveConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPeriodicWaveConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPeriodicWave::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("PeriodicWave"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSPeriodicWaveConstructor::s_info = { "PeriodicWave", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPeriodicWaveConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPeriodicWavePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeriodicWaveConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPeriodicWaveConstructor) } },
};

const ClassInfo JSPeriodicWavePrototype::s_info = { "PeriodicWavePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPeriodicWavePrototype) };

void JSPeriodicWavePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPeriodicWavePrototypeTableValues, *this);
}

const ClassInfo JSPeriodicWave::s_info = { "PeriodicWave", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPeriodicWave) };

JSPeriodicWave::JSPeriodicWave(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PeriodicWave>&& impl)
    : JSDOMWrapper<PeriodicWave>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSPeriodicWave::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSPeriodicWavePrototype::create(vm, globalObject, JSPeriodicWavePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSPeriodicWave::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPeriodicWave>(vm, globalObject);
}

void JSPeriodicWave::destroy(JSC::JSCell* cell)
{
    JSPeriodicWave* thisObject = static_cast<JSPeriodicWave*>(cell);
    thisObject->JSPeriodicWave::~JSPeriodicWave();
}

EncodedJSValue jsPeriodicWaveConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSPeriodicWavePrototype* domObject = jsDynamicCast<JSPeriodicWavePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSPeriodicWave::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSPeriodicWaveConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSPeriodicWavePrototype* domObject = jsDynamicCast<JSPeriodicWavePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSPeriodicWave::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPeriodicWaveConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSPeriodicWaveOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSPeriodicWaveOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPeriodicWave = jsCast<JSPeriodicWave*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPeriodicWave->wrapped(), jsPeriodicWave);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, PeriodicWave* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSPeriodicWave>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, PeriodicWave* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPeriodicWave>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to PeriodicWave.
    COMPILE_ASSERT(!__is_polymorphic(PeriodicWave), PeriodicWave_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSPeriodicWave>(globalObject, impl);
}

PeriodicWave* JSPeriodicWave::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPeriodicWave*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
