/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSPositionError.h"

#include "JSDOMBinding.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsPositionErrorCode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPositionErrorMessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPositionErrorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPositionErrorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSPositionErrorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPositionErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSPositionErrorPrototype>(vm.heap)) JSPositionErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPositionErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSPositionErrorPrototypeTableValues[] =
{
    { "code", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "message", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPositionErrorMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "PERMISSION_DENIED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "POSITION_UNAVAILABLE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TIMEOUT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSPositionErrorPrototype::s_info = { "PositionErrorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPositionErrorPrototype) };

void JSPositionErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPositionErrorPrototypeTableValues, *this);
}

const ClassInfo JSPositionError::s_info = { "PositionError", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPositionError) };

JSPositionError::JSPositionError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PositionError>&& impl)
    : JSDOMWrapper<PositionError>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSPositionError::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSPositionErrorPrototype::create(vm, globalObject, JSPositionErrorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSPositionError::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPositionError>(vm, globalObject);
}

void JSPositionError::destroy(JSC::JSCell* cell)
{
    JSPositionError* thisObject = static_cast<JSPositionError*>(cell);
    thisObject->JSPositionError::~JSPositionError();
}

EncodedJSValue jsPositionErrorCode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPositionError*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PositionError", "code");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.code());
    return JSValue::encode(result);
}


EncodedJSValue jsPositionErrorMessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPositionError*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PositionError", "message");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.message());
    return JSValue::encode(result);
}


void setJSPositionErrorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSPositionErrorPrototype* domObject = jsDynamicCast<JSPositionErrorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

bool JSPositionErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSPositionErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPositionError = jsCast<JSPositionError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPositionError->wrapped(), jsPositionError);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, PositionError* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSPositionError>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, PositionError* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPositionError>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to PositionError.
    COMPILE_ASSERT(!__is_polymorphic(PositionError), PositionError_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSPositionError>(globalObject, impl);
}

PositionError* JSPositionError::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPositionError*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
