/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGDocument.h"

#include "Event.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEvent.h"
#include "JSSVGSVGElement.h"
#include "SVGSVGElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGDocumentPrototypeFunctionCreateEvent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSVGDocumentRootElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGDocumentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGDocumentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGDocumentPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGDocumentPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGDocumentPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGDocumentPrototype>(vm.heap)) JSSVGDocumentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGDocumentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGDocument> JSSVGDocumentConstructor;

template<> JSValue JSSVGDocumentConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSXMLDocument::getConstructor(vm, &globalObject);
}

template<> void JSSVGDocumentConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGDocument::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGDocument"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGDocumentConstructor::s_info = { "SVGDocument", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGDocumentConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGDocumentPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDocumentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGDocumentConstructor) } },
    { "rootElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDocumentRootElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "createEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGDocumentPrototypeFunctionCreateEvent), (intptr_t) (0) } },
};

const ClassInfo JSSVGDocumentPrototype::s_info = { "SVGDocumentPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGDocumentPrototype) };

void JSSVGDocumentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGDocumentPrototypeTableValues, *this);
}

const ClassInfo JSSVGDocument::s_info = { "SVGDocument", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGDocument) };

JSSVGDocument::JSSVGDocument(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGDocument>&& impl)
    : JSXMLDocument(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGDocument::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGDocumentPrototype::create(vm, globalObject, JSSVGDocumentPrototype::createStructure(vm, globalObject, JSXMLDocument::getPrototype(vm, globalObject)));
}

JSObject* JSSVGDocument::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGDocument>(vm, globalObject);
}

EncodedJSValue jsSVGDocumentRootElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGDocument", "rootElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.rootElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsSVGDocumentConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGDocumentPrototype* domObject = jsDynamicCast<JSSVGDocumentPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGDocument::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGDocumentConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGDocumentPrototype* domObject = jsDynamicCast<JSSVGDocumentPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGDocument::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGDocumentConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGDocumentPrototypeFunctionCreateEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGDocument*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGDocument", "createEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String eventType = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createEvent(eventType, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSSVGDocument::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSSVGDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
