/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSTextTrackCueList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSTextTrackCue.h"
#include "TextTrackCue.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackCueListPrototypeFunctionItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackCueListPrototypeFunctionGetCueById(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTextTrackCueListLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextTrackCueListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTextTrackCueListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTextTrackCueListPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTextTrackCueListPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextTrackCueListPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextTrackCueListPrototype>(vm.heap)) JSTextTrackCueListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextTrackCueListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSTextTrackCueList> JSTextTrackCueListConstructor;

template<> JSValue JSTextTrackCueListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTextTrackCueListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTextTrackCueList::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TextTrackCueList"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTextTrackCueListConstructor::s_info = { "TextTrackCueList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextTrackCueListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTextTrackCueListPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackCueListConstructor) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCueListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTextTrackCueListPrototypeFunctionItem), (intptr_t) (1) } },
    { "getCueById", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTextTrackCueListPrototypeFunctionGetCueById), (intptr_t) (1) } },
};

const ClassInfo JSTextTrackCueListPrototype::s_info = { "TextTrackCueListPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextTrackCueListPrototype) };

void JSTextTrackCueListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextTrackCueListPrototypeTableValues, *this);
}

const ClassInfo JSTextTrackCueList::s_info = { "TextTrackCueList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextTrackCueList) };

JSTextTrackCueList::JSTextTrackCueList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextTrackCueList>&& impl)
    : JSDOMWrapper<TextTrackCueList>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTextTrackCueList::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTextTrackCueListPrototype::create(vm, globalObject, JSTextTrackCueListPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSTextTrackCueList::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTextTrackCueList>(vm, globalObject);
}

void JSTextTrackCueList::destroy(JSC::JSCell* cell)
{
    JSTextTrackCueList* thisObject = static_cast<JSTextTrackCueList*>(cell);
    thisObject->JSTextTrackCueList::~JSTextTrackCueList();
}

bool JSTextTrackCueList::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSTextTrackCueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSTextTrackCueList::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSTextTrackCueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsTextTrackCueListLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrackCueList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrackCueList", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackCueListConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTextTrackCueListPrototype* domObject = jsDynamicCast<JSTextTrackCueListPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTextTrackCueList::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTextTrackCueListConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTextTrackCueListPrototype* domObject = jsDynamicCast<JSTextTrackCueListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSTextTrackCueList::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSTextTrackCueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSTextTrackCueList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextTrackCueListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTextTrackCueListPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTextTrackCueList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TextTrackCueList", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTextTrackCueList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTextTrackCueListPrototypeFunctionGetCueById(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTextTrackCueList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TextTrackCueList", "getCueById");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTextTrackCueList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String id = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getCueById(id)));
    return JSValue::encode(result);
}

bool JSTextTrackCueListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSTextTrackCueListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextTrackCueList = jsCast<JSTextTrackCueList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextTrackCueList->wrapped(), jsTextTrackCueList);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, TextTrackCueList* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSTextTrackCueList>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, TextTrackCueList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTextTrackCueList>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TextTrackCueList.
    COMPILE_ASSERT(!__is_polymorphic(TextTrackCueList), TextTrackCueList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSTextTrackCueList>(globalObject, impl);
}

TextTrackCueList* JSTextTrackCueList::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextTrackCueList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
